/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.httpcache4j;

import java.io.InputStream;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.Validate;
import org.codehaus.httpcache4j.CacheControl;
import org.codehaus.httpcache4j.CacheHeaderBuilder;
import org.codehaus.httpcache4j.Directive;
import org.codehaus.httpcache4j.Directives;
import org.codehaus.httpcache4j.HTTPMethod;
import org.codehaus.httpcache4j.Header;
import org.codehaus.httpcache4j.HeaderUtils;
import org.codehaus.httpcache4j.Headers;
import org.codehaus.httpcache4j.Status;
import org.codehaus.httpcache4j.StatusLine;
import org.codehaus.httpcache4j.Tag;
import org.codehaus.httpcache4j.payload.Payload;
import org.joda.time.DateTime;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class HTTPResponse {
    private final StatusLine statusLine;
    private final Payload payload;
    private final Headers headers;
    private DateTime date;
    private DateTime expires;
    private DateTime lastModified;
    private Tag ETag;
    private Set<HTTPMethod> allowedMethods;
    private CacheControl cacheControl;
    private boolean cached;

    public HTTPResponse(Payload payload, Status status, Headers headers) {
        this(payload, new StatusLine(status), headers);
    }

    public HTTPResponse(Payload payload, StatusLine statusLine, Headers headers) {
        Validate.notNull((Object)statusLine, (String)"You must supply a Status");
        Validate.notNull((Object)headers, (String)"You must supply some Headers");
        this.statusLine = statusLine;
        this.payload = payload;
        this.headers = headers;
        if (headers.hasHeader("ETag")) {
            this.ETag = Tag.parse(headers.getFirstHeader("ETag").getValue());
        }
        if (headers.hasHeader("Last-Modified")) {
            this.lastModified = HeaderUtils.fromHttpDate(headers.getFirstHeader("Last-Modified"));
        }
        if (headers.hasHeader("Allow")) {
            Directives value = headers.getFirstHeader("Allow").getDirectives();
            HashSet<HTTPMethod> allowedMethods = new HashSet<HTTPMethod>();
            for (Directive part : value) {
                allowedMethods.add(HTTPMethod.valueOf(part.getName()));
            }
            this.allowedMethods = Collections.unmodifiableSet(allowedMethods);
        }
        if (headers.hasHeader("Cache-Control")) {
            this.cacheControl = new CacheControl(headers.getFirstHeader("Cache-Control").getDirectives());
        }
        if (headers.hasHeader("Date")) {
            this.date = HeaderUtils.fromHttpDate(headers.getFirstHeader("Date"));
        }
        if (headers.hasHeader("Expires")) {
            this.expires = HeaderUtils.fromHttpDate(headers.getFirstHeader("Expires"));
        }
        if (headers.hasHeader("X-Cache")) {
            Header cacheHeader = CacheHeaderBuilder.getBuilder().createHITXCacheHeader();
            List<Header> xcacheHeaders = headers.getHeaders("X-Cache");
            this.cached = xcacheHeaders.contains(cacheHeader);
        }
    }

    public boolean hasPayload() {
        return this.payload != null;
    }

    public Status getStatus() {
        return this.statusLine.getStatus();
    }

    public StatusLine getStatusLine() {
        return this.statusLine;
    }

    public Payload getPayload() {
        return this.payload;
    }

    public Headers getHeaders() {
        return this.headers;
    }

    public Tag getETag() {
        return this.ETag;
    }

    public DateTime getDate() {
        return this.date;
    }

    public DateTime getExpires() {
        return this.expires;
    }

    public DateTime getLastModified() {
        return this.lastModified;
    }

    public CacheControl getCacheControl() {
        return this.cacheControl;
    }

    public boolean isCached() {
        return this.cached;
    }

    public Set<HTTPMethod> getAllowedMethods() {
        return this.allowedMethods != null ? this.allowedMethods : Collections.emptySet();
    }

    public void consume() {
        if (this.hasPayload() && this.payload.isAvailable()) {
            IOUtils.closeQuietly((InputStream)this.payload.getInputStream());
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HTTPResponse response = (HTTPResponse)o;
        if (this.headers != null ? !this.headers.equals(response.headers) : response.headers != null) {
            return false;
        }
        if (this.payload != null ? !this.payload.equals(response.payload) : response.payload != null) {
            return false;
        }
        return this.statusLine == response.statusLine;
    }

    public int hashCode() {
        int result = this.statusLine != null ? this.statusLine.hashCode() : 0;
        result = 31 * result + (this.payload != null ? this.payload.hashCode() : 0);
        result = 31 * result + (this.headers != null ? this.headers.hashCode() : 0);
        return result;
    }
}

