/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.legacyapi.service;

import com.atlassian.confluence.legacyapi.service.Expansion;
import com.google.common.collect.Iterables;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class Expansions {
    public static final Expansions EMPTY = new Expansions(Collections.<Expansion>emptyList());
    private final Map<String, Expansions> expansionsMap;

    public Expansions(Expansion ... expansions) {
        this.expansionsMap = this.merge(new HashMap<String, Expansions>(), expansions);
    }

    public Expansions(Iterable<Expansion> expansions) {
        this((Expansion[])Iterables.toArray(expansions, Expansion.class));
    }

    public Expansions merge(Expansions expansions) {
        return new Expansions(this.merge(this.expansionsMap, expansions.toArray()));
    }

    private Expansions(Map<String, Expansions> expansionsMap) {
        this.expansionsMap = expansionsMap;
    }

    private Map<String, Expansions> merge(Map<String, Expansions> expansionsMap, Expansion ... expansions) {
        for (Expansion expansion : expansions) {
            if (expansionsMap.containsKey(expansion.getPropertyName())) {
                expansionsMap.put(expansion.getPropertyName(), expansionsMap.get(expansion.getPropertyName()).merge(expansion.getSubExpansions()));
                continue;
            }
            expansionsMap.put(expansion.getPropertyName(), expansion.getSubExpansions());
        }
        return expansionsMap;
    }

    public boolean canExpand(String propertyName) {
        return this.expansionsMap.containsKey(propertyName);
    }

    public Expansions getSubExpansions(String propertyName) {
        return this.canExpand(propertyName) ? this.expansionsMap.get(propertyName) : EMPTY;
    }

    public Expansion[] toArray() {
        Expansion[] array = new Expansion[this.expansionsMap.size()];
        int i = 0;
        for (Map.Entry<String, Expansions> stringExpansionsEntry : this.expansionsMap.entrySet()) {
            array[i++] = new Expansion(stringExpansionsEntry.getKey(), stringExpansionsEntry.getValue());
        }
        return array;
    }
}

