/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.legacyapi.model.content.locator;

import com.atlassian.confluence.legacyapi.model.content.ContentType;
import com.atlassian.confluence.legacyapi.model.content.locator.ContentLocatorBuilder;
import org.joda.time.LocalDate;

public final class ContentLocator {
    private final String title;
    private final String spaceKey;
    private final LocalDate postingDay;
    private final ContentType[] contentTypes;

    public static ContentLocatorBuilder builder() {
        return new ContentLocatorBuilder();
    }

    ContentLocator(String title, String spaceKey, LocalDate postingDay, ContentType ... contentTypes) {
        this.title = title;
        this.spaceKey = spaceKey;
        this.postingDay = postingDay;
        this.contentTypes = contentTypes;
    }

    public String getTitle() {
        return this.title;
    }

    public String getSpaceKey() {
        return this.spaceKey;
    }

    public LocalDate getPostingDay() {
        return this.postingDay;
    }

    public ContentType[] getContentTypes() {
        return this.contentTypes;
    }

    public boolean isForContent(ContentType contentType) {
        return this.contentTypes.length == 1 && this.contentTypes[0].equals(contentType);
    }
}

