/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.legacyapi.model.content;

import org.codehaus.jackson.annotate.JsonProperty;

public final class ContentType {
    @JsonProperty
    private final String type;
    public static final ContentType PAGE = new ContentType("page");
    public static final ContentType BLOG_POST = new ContentType("blogpost");
    public static final ContentType COMMENT = new ContentType("comment");
    public static final ContentType STATUS_UPDATE = new ContentType("status");
    public static final ContentType SPACE_DESCRIPTION = new ContentType("spacedesc");
    public static final ContentType GLOBAL_DESCRIPTION = new ContentType("globaldescription");
    public static final ContentType PERSONAL_INFORMATION = new ContentType("userinfo");
    private static final ContentType[] BUILT_IN = new ContentType[]{PAGE, BLOG_POST, COMMENT, STATUS_UPDATE, SPACE_DESCRIPTION, GLOBAL_DESCRIPTION, PERSONAL_INFORMATION};

    public static ContentType forName(String typeName) {
        for (ContentType contentType : BUILT_IN) {
            if (!typeName.equals(contentType.getType())) continue;
            return contentType;
        }
        return new ContentType(typeName);
    }

    private ContentType(String type) {
        this.type = type;
    }

    public String getType() {
        return this.type;
    }
}

