/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.ws.soap.soap11.encoder.http;

import java.util.List;
import org.opensaml.ws.message.MessageContext;
import org.opensaml.ws.message.encoder.MessageEncodingException;
import org.opensaml.ws.soap.soap11.Envelope;
import org.opensaml.ws.soap.soap11.Header;
import org.opensaml.ws.soap.soap11.encoder.SOAP11Encoder;
import org.opensaml.ws.transport.http.HTTPOutTransport;
import org.opensaml.ws.transport.http.HTTPTransportUtils;
import org.opensaml.ws.wsaddressing.Action;
import org.opensaml.xml.XMLObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HTTPSOAP11Encoder
extends SOAP11Encoder {
    private final Logger log = LoggerFactory.getLogger(HTTPSOAP11Encoder.class);

    @Override
    protected void doEncode(MessageContext messageContext) throws MessageEncodingException {
        if (!(messageContext.getOutboundMessageTransport() instanceof HTTPOutTransport)) {
            this.log.error("Invalid outbound message transport type, this encoder only support HTTPOutTransport");
            throw new MessageEncodingException("Invalid outbound message transport type, this encoder only support HTTPOutTransport");
        }
        super.doEncode(messageContext);
    }

    @Override
    protected void preprocessTransport(MessageContext messageContext) throws MessageEncodingException {
        HTTPOutTransport outTransport = (HTTPOutTransport)messageContext.getOutboundMessageTransport();
        HTTPTransportUtils.addNoCacheHeaders(outTransport);
        HTTPTransportUtils.setUTF8Encoding(outTransport);
        HTTPTransportUtils.setContentType(outTransport, "text/xml");
        String soapAction = this.getSOAPAction(messageContext);
        if (soapAction != null) {
            outTransport.setHeader("SOAPAction", soapAction);
        } else {
            outTransport.setHeader("SOAPAction", "");
        }
    }

    protected String getSOAPAction(MessageContext messageContext) {
        Envelope env = (Envelope)messageContext.getOutboundMessage();
        Header header = env.getHeader();
        if (header == null) {
            return null;
        }
        List<XMLObject> objList = header.getUnknownXMLObjects(Action.ELEMENT_NAME);
        if (objList == null || objList.isEmpty()) {
            return null;
        }
        return ((Action)objList.get(0)).getValue();
    }
}

