/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml2.metadata.provider;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Timer;
import org.apache.commons.httpclient.HttpClient;
import org.opensaml.saml2.metadata.provider.HTTPMetadataProvider;
import org.opensaml.saml2.metadata.provider.MetadataProviderException;
import org.opensaml.xml.XMLObject;
import org.opensaml.xml.util.DatatypeHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;

public class FileBackedHTTPMetadataProvider
extends HTTPMetadataProvider {
    private final Logger log = LoggerFactory.getLogger(FileBackedHTTPMetadataProvider.class);
    private File metadataBackupFile;

    @Deprecated
    public FileBackedHTTPMetadataProvider(String metadataURL, int requestTimeout, String backupFilePath) throws MetadataProviderException {
        super(metadataURL, requestTimeout);
        this.setBackupFile(backupFilePath);
    }

    public FileBackedHTTPMetadataProvider(Timer backgroundTaskTimer, HttpClient client, String metadataURL, String backupFilePath) throws MetadataProviderException {
        super(backgroundTaskTimer, client, metadataURL);
        this.setBackupFile(backupFilePath);
    }

    @Override
    public synchronized void destroy() {
        this.metadataBackupFile = null;
        super.destroy();
    }

    @Override
    protected void doInitialization() throws MetadataProviderException {
        try {
            this.validateBackupFile(this.metadataBackupFile);
        }
        catch (MetadataProviderException e) {
            if (this.isFailFastInitialization()) {
                this.log.error("Metadata backup file path was invalid, initialization is fatal");
                throw e;
            }
            this.log.error("Metadata backup file path was invalid, continuing without known good backup file");
        }
        super.doInitialization();
    }

    protected void setBackupFile(String backupFilePath) throws MetadataProviderException {
        File backingFile;
        this.metadataBackupFile = backingFile = new File(backupFilePath);
    }

    protected void validateBackupFile(File backupFile) throws MetadataProviderException {
        if (!backupFile.exists()) {
            try {
                backupFile.createNewFile();
            }
            catch (IOException e) {
                this.log.error("Unable to create backing file " + backupFile, (Throwable)e);
                throw new MetadataProviderException("Unable to create backing file " + backupFile.getAbsolutePath(), e);
            }
        }
        if (backupFile.isDirectory()) {
            throw new MetadataProviderException("Filepath " + backupFile.getAbsolutePath() + " is a directory and may not be used as a backing metadata file");
        }
        if (!backupFile.canRead()) {
            throw new MetadataProviderException("Filepath " + backupFile.getAbsolutePath() + " exists but can not be read by this user");
        }
        if (!backupFile.canWrite()) {
            throw new MetadataProviderException("Filepath " + backupFile.getAbsolutePath() + " exists but can not be written to by this user");
        }
    }

    @Override
    protected byte[] fetchMetadata() throws MetadataProviderException {
        try {
            return super.fetchMetadata();
        }
        catch (MetadataProviderException e) {
            if (this.metadataBackupFile.exists()) {
                try {
                    return DatatypeHelper.fileToByteArray(this.metadataBackupFile);
                }
                catch (IOException ioe) {
                    String errMsg = "Unable to retrieve metadata from backup file " + this.metadataBackupFile.getAbsolutePath();
                    this.log.error(errMsg, (Throwable)ioe);
                    throw new MetadataProviderException(errMsg, ioe);
                }
            }
            this.log.error("Unable to read metadata from remote server and backup does not exist");
            throw new MetadataProviderException("Unable to read metadata from remote server and backup does not exist");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void postProcessMetadata(byte[] metadataBytes, Document metadataDom, XMLObject metadata) throws MetadataProviderException {
        try {
            this.validateBackupFile(this.metadataBackupFile);
            FileOutputStream out = new FileOutputStream(this.metadataBackupFile);
            out.write(metadataBytes);
            out.flush();
            out.close();
        }
        catch (MetadataProviderException e) {
            this.log.error("Unable to write metadata to backup file: " + this.metadataBackupFile.getAbsoluteFile(), (Throwable)e);
        }
        catch (IOException e) {
            this.log.error("Unable to write metadata to backup file: " + this.metadataBackupFile.getAbsoluteFile(), (Throwable)e);
        }
        finally {
            super.postProcessMetadata(metadataBytes, metadataDom, metadata);
        }
    }
}

