/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml2.core.validator;

import org.opensaml.saml2.core.Assertion;
import org.opensaml.xml.validation.ValidationException;
import org.opensaml.xml.validation.Validator;

public class AssertionSpecValidator
implements Validator<Assertion> {
    @Override
    public void validate(Assertion assertion) throws ValidationException {
        this.validateSubject(assertion);
    }

    protected void validateSubject(Assertion assertion) throws ValidationException {
        if (!(assertion.getStatements() != null && assertion.getStatements().size() != 0 || assertion.getAuthnStatements() != null && assertion.getAuthnStatements().size() != 0 || assertion.getAttributeStatements() != null && assertion.getAttributeStatements().size() != 0 || assertion.getAuthzDecisionStatements() != null && assertion.getAuthzDecisionStatements().size() != 0 || assertion.getSubject() != null)) {
            throw new ValidationException("Subject is required when Statements are absent");
        }
        if (assertion.getAuthnStatements().size() > 0 && assertion.getSubject() == null) {
            throw new ValidationException("Assertions containing AuthnStatements require a Subject");
        }
        if (assertion.getAuthzDecisionStatements().size() > 0 && assertion.getSubject() == null) {
            throw new ValidationException("Assertions containing AuthzDecisionStatements require a Subject");
        }
        if (assertion.getAttributeStatements().size() > 0 && assertion.getSubject() == null) {
            throw new ValidationException("Assertions containing AttributeStatements require a Subject");
        }
    }
}

