/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml1.core.validator;

import javax.xml.namespace.QName;
import org.opensaml.saml1.core.AuthorityBinding;
import org.opensaml.xml.util.DatatypeHelper;
import org.opensaml.xml.validation.ValidationException;
import org.opensaml.xml.validation.Validator;

public class AuthorityBindingSchemaValidator
implements Validator<AuthorityBinding> {
    @Override
    public void validate(AuthorityBinding authorityBinding) throws ValidationException {
        this.validateAuthorityKind(authorityBinding);
        this.validateBinding(authorityBinding);
        this.validateLocation(authorityBinding);
    }

    protected void validateAuthorityKind(AuthorityBinding authorityBinding) throws ValidationException {
        QName authorityKind = authorityBinding.getAuthorityKind();
        if (authorityKind == null) {
            throw new ValidationException("No AuthorityKind attribute present");
        }
    }

    protected void validateLocation(AuthorityBinding authorityBinding) throws ValidationException {
        if (DatatypeHelper.isEmpty(authorityBinding.getLocation())) {
            throw new ValidationException("Location attribute not present or invalid ");
        }
    }

    protected void validateBinding(AuthorityBinding authorityBinding) throws ValidationException {
        if (DatatypeHelper.isEmpty(authorityBinding.getBinding())) {
            throw new ValidationException("Binding attribute not present or invalid ");
        }
    }
}

