/*
 * Decompiled with CFR 0.152.
 */
package com.miniorange.sso.saml.confluence.servlet;

import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.sal.api.auth.LoginUriProvider;
import com.miniorange.sso.saml.confluence.SAMLSettings;
import java.io.IOException;
import java.net.URI;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class SAMLLoginFilter
implements Filter {
    private SAMLSettings settings;
    private LoginUriProvider loginUriProvider;

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        try {
            HttpServletRequest req = (HttpServletRequest)request;
            HttpServletResponse res = (HttpServletResponse)response;
            URI loginUri = this.loginUriProvider.getLoginUri(new URI(req.getRequestURI().toString()));
            ConfluenceUser confluenceUser = AuthenticatedUserThreadLocal.get();
            if (confluenceUser != null) {
                chain.doFilter(request, response);
            } else {
                Boolean defaultLoginDisabled = this.settings.getDefaultLoginDisabled();
                if (defaultLoginDisabled.booleanValue()) {
                    res.sendRedirect(loginUri.toString());
                } else {
                    chain.doFilter(request, response);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void destroy() {
    }

    public void setSettings(SAMLSettings settings) {
        this.settings = settings;
    }

    public void setLoginUriProvider(LoginUriProvider loginUriProvider) {
        this.loginUriProvider = loginUriProvider;
    }
}

