/*
 * Decompiled with CFR 0.152.
 */
package com.miniorange.sso.saml.confluence;

import com.atlassian.confluence.core.ConfluenceActionSupport;
import com.miniorange.sso.saml.Customer;
import com.miniorange.sso.saml.PluginException;
import com.miniorange.sso.saml.PluginHandler;
import com.miniorange.sso.saml.confluence.SAMLSettings;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;

public class LoginAction
extends ConfluenceActionSupport {
    private Boolean submitted;
    private SAMLSettings settings;
    private String email;
    private String password;

    public void validate() {
        if (!BooleanUtils.toBoolean((Boolean)this.submitted)) {
            return;
        }
        if (StringUtils.isBlank((CharSequence)this.email)) {
            this.addActionError(this.getText("samlsso.error.register.email.empty"));
        }
        if (StringUtils.isBlank((CharSequence)this.password)) {
            this.addActionError(this.getText("samlsso.error.register.password.empty"));
        }
        if (StringUtils.length((CharSequence)this.password) < 6) {
            this.addActionError(this.getText("samlsso.error.register.password.min.length"));
        }
    }

    public String execute() {
        if (this.settings.isCustomerRegistered().booleanValue()) {
            return "redirect";
        }
        if (BooleanUtils.toBoolean((Boolean)this.submitted)) {
            try {
                PluginHandler handler = new PluginHandler();
                Boolean exists = handler.checkIfCustomerExists(this.email);
                if (exists.booleanValue()) {
                    try {
                        Customer customer = handler.fetchCustomer(this.email, this.password);
                        this.settings.setCustomerId(customer.getCustomerId().toString());
                        this.settings.setCustomerEmail(customer.getEmail());
                        this.settings.setCustomerAPIKey(customer.getApiKey());
                        this.settings.setCustomerTokenKey(customer.getTokenKey());
                        this.settings.setCustomerRegisteredBefore209();
                        return "success";
                    }
                    catch (PluginException e) {
                        this.addActionError("Invalid username or password. Please try again.");
                        return "input";
                    }
                }
                this.addActionError("You are not registered with miniOrange. Click on Register link below.");
                return "input";
            }
            catch (Exception e) {
                e.printStackTrace();
                this.addActionError("There was an error processing your request. Please verify that your server is connected to internet. To skip login, contact us at info@miniorange.com");
                return "error";
            }
        }
        return "input";
    }

    public Boolean getSubmitted() {
        return this.submitted;
    }

    public void setSubmitted(Boolean submitted) {
        this.submitted = submitted;
    }

    public SAMLSettings getSettings() {
        return this.settings;
    }

    public void setSettings(SAMLSettings settings) {
        this.settings = settings;
    }

    public String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }
}

