/*
 * Decompiled with CFR 0.152.
 */
package com.miniorange.sso.saml;

import com.miniorange.sso.saml.SAMLException;
import com.miniorange.sso.saml.SAMLResponse;
import com.miniorange.sso.saml.SAMLUtils;
import com.miniorange.sso.saml.confluence.SAMLSettings;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.security.cert.CertificateException;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.joda.time.DateTime;
import org.opensaml.Configuration;
import org.opensaml.DefaultBootstrap;
import org.opensaml.saml2.core.Assertion;
import org.opensaml.saml2.core.Attribute;
import org.opensaml.saml2.core.Audience;
import org.opensaml.saml2.core.AuthnRequest;
import org.opensaml.saml2.core.NameID;
import org.opensaml.saml2.core.Response;
import org.opensaml.xml.io.Marshaller;
import org.opensaml.xml.validation.ValidationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class SAMLManager {
    private static Log LOGGER = LogFactory.getLog(SAMLManager.class);
    private SAMLSettings settings;

    public void createAuthnRequestAndRedirect(HttpServletRequest request, HttpServletResponse response, String relayState) {
        try {
            LOGGER.debug("Creating AuthnRequest...");
            DefaultBootstrap.bootstrap();
            AuthnRequest authnRequest = SAMLUtils.buildAuthnRequest(this.settings.getBaseUrl(), this.settings.getLoginServletUrl(), this.settings.getSsoServiceUrl());
            String encodedAuthnRequest = SAMLUtils.base64EncodeRequest(authnRequest);
            String redirectUrl = this.createRedirectURL(this.settings.getSsoServiceUrl(), encodedAuthnRequest, relayState);
            LOGGER.debug("Redirecting to " + this.settings.getSsoServiceUrl() + " for Authentication.");
            response.sendRedirect(redirectUrl);
        }
        catch (Throwable t) {
            LOGGER.error("An error occurred while creating the AuthnRequest.", t);
            throw new SAMLException(SAMLException.SAMLErrorCode.UNKNOWN);
        }
    }

    public String getTestAuthnRequest() {
        try {
            System.out.println("hehre");
            LOGGER.debug("Creating AuthnRequest...");
            DefaultBootstrap.bootstrap();
            AuthnRequest authnRequest = SAMLUtils.buildAuthnRequest(this.settings.getBaseUrl(), this.settings.getLoginServletUrl(), this.settings.getSsoServiceUrl());
            Marshaller marshaller = Configuration.getMarshallerFactory().getMarshaller(authnRequest);
            Element authDOM = marshaller.marshall(authnRequest);
            Document doc = authDOM.getOwnerDocument();
            Transformer tf = TransformerFactory.newInstance().newTransformer();
            tf.setOutputProperty("encoding", "UTF-8");
            tf.setOutputProperty("indent", "yes");
            StringWriter out = new StringWriter();
            tf.transform(new DOMSource(doc), new StreamResult(out));
            System.out.println(((Object)out).toString());
            String requestMessage = ((Object)out).toString();
            return requestMessage;
        }
        catch (Throwable t) {
            LOGGER.error("An error occurred while creating the AuthnRequest.", t);
            throw new SAMLException(SAMLException.SAMLErrorCode.UNKNOWN);
        }
    }

    public SAMLResponse readSAMLResponse(HttpServletRequest request, HttpServletResponse response) {
        try {
            LOGGER.debug("Verifying SAML Response...");
            DefaultBootstrap.bootstrap();
            String encodedSAMLResponse = request.getParameter("SAMLResponse");
            String relayState = request.getParameter("RelayState");
            Response samlResponse = SAMLUtils.decodeResponse(encodedSAMLResponse);
            if (!StringUtils.equals((CharSequence)samlResponse.getStatus().getStatusCode().getValue(), (CharSequence)"urn:oasis:names:tc:SAML:2.0:status:Success")) {
                LOGGER.error("Invalid SAML response. SAML Status Code received: " + samlResponse.getStatus().getStatusCode().getValue());
                throw new SAMLException(SAMLException.SAMLErrorCode.UNKNOWN);
            }
            this.verifyConditions(samlResponse.getAssertions().get(0), this.settings.getBaseUrl());
            this.verifyIssuer(samlResponse, this.settings.getIdpEntityId());
            this.verifyDestination(samlResponse, this.settings.getLoginServletUrl());
            this.verifyRecipient(samlResponse, this.settings.getLoginServletUrl());
            this.verifyCertificate(samlResponse, this.settings.getX509Certificate());
            Map<String, String[]> attributes = this.getAttributes(samlResponse);
            NameID nameId = samlResponse.getAssertions().get(0).getSubject().getNameID();
            String nameIdValue = "";
            if (nameId != null) {
                nameIdValue = nameId.getValue();
            }
            attributes.put("NameID", new String[]{nameIdValue});
            SAMLResponse samlResponseObj = new SAMLResponse(attributes, nameIdValue, relayState);
            return samlResponseObj;
        }
        catch (SAMLException e) {
            LOGGER.error(e.getMessage(), e);
            throw e;
        }
        catch (Throwable e) {
            LOGGER.error("An error occurred while verifying the SAML Response.", e);
            throw new SAMLException(e, SAMLException.SAMLErrorCode.UNKNOWN);
        }
    }

    private void verifyIssuer(Response response, String idpEntityId) {
        LOGGER.debug("Verifying Issuer in Response and Assertion...");
        String issuerInResponse = response.getIssuer().getValue();
        String issuerInAssertion = response.getAssertions().get(0).getIssuer().getValue();
        if (!StringUtils.equals((CharSequence)issuerInResponse, (CharSequence)idpEntityId)) {
            SAMLException.SAMLErrorCode errorCode = SAMLException.SAMLErrorCode.INVALID_ISSUER;
            SAMLException e = new SAMLException(errorCode.getMessage(), this.buildResolutionMessage(errorCode, idpEntityId, issuerInResponse), errorCode);
            LOGGER.debug(e.getMessage(), e);
            throw e;
        }
        if (!StringUtils.equals((CharSequence)issuerInAssertion, (CharSequence)idpEntityId)) {
            SAMLException.SAMLErrorCode errorCode = SAMLException.SAMLErrorCode.INVALID_ISSUER;
            SAMLException e = new SAMLException(errorCode.getMessage(), this.buildResolutionMessage(errorCode, idpEntityId, issuerInAssertion), errorCode);
            LOGGER.debug(e.getMessage(), e);
            throw e;
        }
    }

    private void verifyDestination(Response response, String acsUrl) {
        LOGGER.debug("Verifying Destination if present...");
        String destInResponse = response.getDestination();
        if (StringUtils.isBlank((CharSequence)destInResponse) || StringUtils.equals((CharSequence)destInResponse, (CharSequence)acsUrl)) {
            return;
        }
        SAMLException.SAMLErrorCode errorCode = SAMLException.SAMLErrorCode.INVALID_DESTINATION;
        SAMLException e = new SAMLException(errorCode.getMessage(), this.buildResolutionMessage(errorCode, acsUrl, destInResponse), errorCode);
        LOGGER.debug(e.getMessage(), e);
        throw e;
    }

    private void verifyRecipient(Response response, String acsUrl) {
        LOGGER.debug("Verifying Recipient if present...");
        String recipientInResponse = response.getAssertions().get(0).getSubject().getSubjectConfirmations().get(0).getSubjectConfirmationData().getRecipient();
        if (StringUtils.isBlank((CharSequence)recipientInResponse) || StringUtils.equals((CharSequence)recipientInResponse, (CharSequence)acsUrl)) {
            return;
        }
        SAMLException.SAMLErrorCode errorCode = SAMLException.SAMLErrorCode.INVALID_RECIPIENT;
        SAMLException e = new SAMLException(errorCode.getMessage(), this.buildResolutionMessage(errorCode, acsUrl, recipientInResponse), errorCode);
        LOGGER.debug(e.getMessage(), e);
        throw e;
    }

    private void verifyCertificate(Response response, String x509Certificate) {
        LOGGER.debug("Verifying Certificate...");
        try {
            if (!response.isSigned() && !response.getAssertions().get(0).isSigned()) {
                SAMLException e = new SAMLException(SAMLException.SAMLErrorCode.ASSERTION_NOT_SIGNED);
                LOGGER.error(SAMLException.SAMLErrorCode.ASSERTION_NOT_SIGNED.getMessage(), e);
                throw e;
            }
            if (response.isSigned()) {
                SAMLUtils.verifyCertificate(response, x509Certificate);
            }
            if (response.getAssertions().get(0).isSigned()) {
                SAMLUtils.verifyCertificate(response.getAssertions().get(0), x509Certificate);
            }
        }
        catch (CertificateException e) {
            LOGGER.error(SAMLException.SAMLErrorCode.INVALID_CERTIFICATE.getMessage(), e);
            throw new SAMLException(SAMLException.SAMLErrorCode.INVALID_CERTIFICATE);
        }
        catch (ValidationException e) {
            LOGGER.error(SAMLException.SAMLErrorCode.INVALID_CERTIFICATE.getMessage(), e);
            throw new SAMLException(SAMLException.SAMLErrorCode.INVALID_CERTIFICATE);
        }
    }

    private void verifyConditions(Assertion assertion, String audienceExpected) {
        LOGGER.debug("Verifying Conditions...");
        Date now = new DateTime().toDate();
        Date notBefore = null;
        Date notOnOrAfter = null;
        if (assertion.getConditions().getNotBefore() != null) {
            notBefore = assertion.getConditions().getNotBefore().minusSeconds(15).toDate();
        }
        if (assertion.getConditions().getNotOnOrAfter() != null) {
            notOnOrAfter = assertion.getConditions().getNotOnOrAfter().plusSeconds(15).toDate();
        }
        if (notBefore != null && now.before(notBefore)) {
            SAMLException e = new SAMLException(SAMLException.SAMLErrorCode.INVALID_CONDITIONS);
            LOGGER.error("Received an assertion that is valid in the future. Check clock synchronization on IDP and SP.", e);
            throw e;
        }
        if (notOnOrAfter != null && (now.after(notOnOrAfter) || now.equals(notOnOrAfter))) {
            SAMLException e = new SAMLException(SAMLException.SAMLErrorCode.INVALID_CONDITIONS);
            LOGGER.error("Received an assertion with a session that has expired. Check clock synchronization on IDP and SP.", e);
            throw e;
        }
        List<Audience> audiencesInAssertion = assertion.getConditions().getAudienceRestrictions().get(0).getAudiences();
        for (Audience audience : audiencesInAssertion) {
            if (!StringUtils.equalsIgnoreCase((CharSequence)audience.getAudienceURI(), (CharSequence)audienceExpected)) continue;
            return;
        }
        SAMLException e = new SAMLException(SAMLException.SAMLErrorCode.INVALID_AUDIENCE);
        LOGGER.error(SAMLException.SAMLErrorCode.INVALID_AUDIENCE.getMessage(), e);
        throw e;
    }

    private Map<String, String[]> getAttributes(Response response) {
        HashMap<String, String[]> attributes = new HashMap<String, String[]>();
        if (response.getAssertions().get(0).getAttributeStatements().size() > 0) {
            for (Attribute attr : response.getAssertions().get(0).getAttributeStatements().get(0).getAttributes()) {
                if (attr.getAttributeValues().size() <= 0) continue;
                String[] values = new String[attr.getAttributeValues().size()];
                for (int i = 0; i < attr.getAttributeValues().size(); ++i) {
                    values[i] = attr.getAttributeValues().get(i).getDOM().getTextContent();
                }
                attributes.put(attr.getName(), values);
            }
        }
        return attributes;
    }

    private String createRedirectURL(String ssoURL, String authnRequest, String relayState) throws UnsupportedEncodingException {
        StringBuilder builder = new StringBuilder(ssoURL);
        if (StringUtils.contains((CharSequence)ssoURL, (CharSequence)"?") && !StringUtils.endsWith((CharSequence)ssoURL, (CharSequence)"?") && !StringUtils.endsWith((CharSequence)ssoURL, (CharSequence)"&")) {
            builder.append("&");
        } else if (!StringUtils.contains((CharSequence)ssoURL, (CharSequence)"?")) {
            builder.append("?");
        }
        builder.append(this.createQueryParams(authnRequest, relayState));
        return builder.toString();
    }

    private String createQueryParams(String httpRedirectRequest, String relayState) throws UnsupportedEncodingException {
        StringBuffer urlForSignature = new StringBuffer();
        urlForSignature.append("SAMLRequest").append("=").append(URLEncoder.encode(httpRedirectRequest, StandardCharsets.UTF_8.toString()));
        urlForSignature.append("&").append("RelayState").append("=");
        if (StringUtils.isNotBlank((CharSequence)relayState)) {
            urlForSignature.append(URLEncoder.encode(relayState, StandardCharsets.UTF_8.toString()));
        } else {
            urlForSignature.append(URLEncoder.encode("/", StandardCharsets.UTF_8.toString()));
        }
        return urlForSignature.toString();
    }

    private String buildResolutionMessage(SAMLException.SAMLErrorCode error, String expected, String found) {
        StringBuffer errorMsg = new StringBuffer(error.getResolution());
        errorMsg.append(" Add-on was expecting ");
        errorMsg.append(expected);
        errorMsg.append(" but found: ");
        errorMsg.append(found);
        return errorMsg.toString();
    }

    public void setSettings(SAMLSettings settings) {
        this.settings = settings;
    }
}

