/*
 * Decompiled with CFR 0.152.
 */
package com.miniorange.sso.saml;

import com.atlassian.json.jsonorg.JSONArray;
import com.atlassian.json.jsonorg.JSONException;
import com.atlassian.json.jsonorg.JSONObject;
import com.miniorange.sso.saml.APIRequest;
import com.miniorange.sso.saml.Customer;
import com.miniorange.sso.saml.HttpUtils;
import com.miniorange.sso.saml.PluginException;
import com.miniorange.sso.saml.confluence.SAMLSettings;
import java.util.HashMap;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang3.StringUtils;

public class PluginHandler {
    private SAMLSettings settings;

    private static HashMap<String, String> getAuthorizationHeaders(Long customerId, String apiKey) {
        HashMap<String, String> headers = new HashMap<String, String>();
        Long timestamp = System.currentTimeMillis();
        String stringToHash = customerId + timestamp + apiKey;
        String hashValue = DigestUtils.sha512Hex(stringToHash);
        headers.put("Customer-Key", String.valueOf(customerId));
        headers.put("Timestamp", String.valueOf(timestamp));
        headers.put("Authorization", hashValue);
        return headers;
    }

    private static Boolean isJSONString(String string) {
        try {
            new JSONObject(string);
        }
        catch (JSONException ex) {
            try {
                new JSONArray(string);
            }
            catch (JSONException ex1) {
                return false;
            }
        }
        return true;
    }

    public Boolean checkIfCustomerExists(String email) {
        try {
            JSONObject jsonObject;
            String status;
            Customer customer;
            String json;
            String response;
            if (StringUtils.isNotBlank((CharSequence)email) && PluginHandler.isJSONString(response = HttpUtils.sendPostRequest("https://auth.miniorange.com/moas/rest/customer/check-if-exists", json = (customer = new Customer(email, null, null, null, null)).getJSON(), "application/json", PluginHandler.getAuthorizationHeaders(Long.valueOf("16555"), "16555"))).booleanValue() && StringUtils.equalsIgnoreCase((CharSequence)(status = (jsonObject = new JSONObject(response)).getString("status")), (CharSequence)"success")) {
                return Boolean.TRUE;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new PluginException(PluginException.PluginErrorCode.UNKNOWN, "", e);
        }
        return Boolean.FALSE;
    }

    public Customer createCustomer(String email, String password, String phone, String fname, String lname, String companyName) {
        try {
            Customer customer = new Customer(email, password, phone, fname, lname);
            customer.setCompanyName(companyName);
            customer.setAreaOfInterest("Confluence - SAML Single Sign On Plugin");
            String json = customer.getJSON();
            String response = HttpUtils.sendPostRequest("https://auth.miniorange.com/moas/rest/customer/add", json, "application/json", PluginHandler.getAuthorizationHeaders(Long.valueOf("16555"), "fFd2XcvTGDemZvbw1bcUesNJWEqKbbUq"));
            if (PluginHandler.isJSONString(response).booleanValue()) {
                JSONObject jsonObject = new JSONObject(response);
                String status = jsonObject.getString("status");
                if (StringUtils.equalsIgnoreCase((CharSequence)status, (CharSequence)"success")) {
                    Long customerId = jsonObject.getLong("id");
                    customer = new Customer(customerId, email, "", phone, fname, lname);
                    return customer;
                }
                throw new PluginException(PluginException.PluginErrorCode.UNKNOWN, "Status not Success", null);
            }
            throw new PluginException(PluginException.PluginErrorCode.UNKNOWN, "Response not JSON", null);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new PluginException(PluginException.PluginErrorCode.UNKNOWN, "", e);
        }
    }

    public Customer fetchCustomer(String email, String password) {
        try {
            Customer customer = new Customer(email, password, "", "", "");
            String json = customer.getJSON();
            String response = HttpUtils.sendPostRequest("https://auth.miniorange.com/moas/rest/customer/key", json, "application/json", PluginHandler.getAuthorizationHeaders(Long.valueOf("16555"), "fFd2XcvTGDemZvbw1bcUesNJWEqKbbUq"));
            if (PluginHandler.isJSONString(response).booleanValue()) {
                JSONObject jsonObject = new JSONObject(response);
                String status = jsonObject.getString("status");
                if (StringUtils.equalsIgnoreCase((CharSequence)status, (CharSequence)"success")) {
                    Long customerId = jsonObject.getLong("id");
                    customer = new Customer(customerId, email, "", "", "", "");
                    customer.setApiKey(jsonObject.getString("apiKey"));
                    customer.setTokenKey(jsonObject.getString("token"));
                    return customer;
                }
                throw new PluginException(PluginException.PluginErrorCode.UNKNOWN, "Status not Success", null);
            }
            throw new PluginException(PluginException.PluginErrorCode.UNKNOWN, "Response not JSON", null);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new PluginException(PluginException.PluginErrorCode.UNKNOWN, "", e);
        }
    }

    public String sendOTPToken(String email) {
        try {
            APIRequest request = new APIRequest("16555", email, "EMAIL", null, null);
            String json = request.getJSON();
            String response = HttpUtils.sendPostRequest("https://auth.miniorange.com/moas/api/auth/challenge", json, "application/json", PluginHandler.getAuthorizationHeaders(Long.valueOf("16555"), "fFd2XcvTGDemZvbw1bcUesNJWEqKbbUq"));
            if (PluginHandler.isJSONString(response).booleanValue()) {
                JSONObject jsonObject = new JSONObject(response);
                String status = jsonObject.getString("status");
                if (StringUtils.equalsIgnoreCase((CharSequence)status, (CharSequence)"success")) {
                    String txId = jsonObject.getString("txId");
                    return txId;
                }
                throw new PluginException(PluginException.PluginErrorCode.UNKNOWN, "Status not Success", null);
            }
            throw new PluginException(PluginException.PluginErrorCode.UNKNOWN, "Response not JSON", null);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new PluginException(PluginException.PluginErrorCode.UNKNOWN, "", e);
        }
    }

    public Boolean validateOTPToken(String txId, String token) {
        try {
            APIRequest request = new APIRequest(null, null, "EMAIL", txId, token);
            String json = request.getJSON();
            String response = HttpUtils.sendPostRequest("https://auth.miniorange.com/moas/api/auth/validate", json, "application/json", PluginHandler.getAuthorizationHeaders(Long.valueOf("16555"), "fFd2XcvTGDemZvbw1bcUesNJWEqKbbUq"));
            if (PluginHandler.isJSONString(response).booleanValue()) {
                JSONObject jsonObject = new JSONObject(response);
                String status = jsonObject.getString("status");
                if (StringUtils.equalsIgnoreCase((CharSequence)status, (CharSequence)"success")) {
                    return true;
                }
                return false;
            }
            throw new PluginException(PluginException.PluginErrorCode.UNKNOWN, "Response not JSON", null);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new PluginException(PluginException.PluginErrorCode.UNKNOWN, "", e);
        }
    }

    public void submitSupportQuery(String email, String phone, String query) {
        try {
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("company", (Object)this.settings.getBaseUrl());
            jsonObject.put("email", (Object)email);
            jsonObject.put("phone", (Object)phone);
            jsonObject.put("query", (Object)StringUtils.prependIfMissing((String)query, (CharSequence)"[Confluence SAML SSO Plugin] ", (CharSequence[])new CharSequence[0]));
            String json = jsonObject.toString();
            String response = HttpUtils.sendPostRequest("https://auth.miniorange.com/moas/rest/customer/contact-us", json, "application/json", PluginHandler.getAuthorizationHeaders(Long.valueOf(this.settings.getCustomerID()), this.settings.getCustomerAPIKey()));
            System.out.println("Submit Query response: " + response);
        }
        catch (Exception e) {
            System.out.println("An error occurred while saving your details.");
            throw new PluginException(PluginException.PluginErrorCode.UNKNOWN, "An error occurred while saving your details. Please check logs for more info.", e);
        }
    }

    public void setSettings(SAMLSettings settings) {
        this.settings = settings;
    }
}

