/*
 * Decompiled with CFR 0.152.
 */
package com.miniorange.sso.saml;

import com.miniorange.sso.saml.PluginException;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.ProxySelector;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.net.ssl.SSLContext;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.config.Lookup;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.routing.HttpRoutePlanner;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLContextBuilder;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.BasicHttpClientConnectionManager;
import org.apache.http.impl.conn.SystemDefaultRoutePlanner;

public class HttpUtils {
    public static final String CONTENT_TYPE_JSON = "application/json";

    public static String sendGetRequest(String url) throws Exception {
        try {
            String output;
            CloseableHttpClient httpClient = HttpUtils.getHttpClient();
            HttpGet getRequest = new HttpGet(url);
            System.out.println("Sending HTTP Request to URL " + url);
            CloseableHttpResponse response = httpClient.execute((HttpUriRequest)getRequest);
            System.out.println("Response for HTTP Request to URL " + url + " response: " + response.toString() + " \n status code: " + response.getStatusLine().getStatusCode());
            BufferedReader br = new BufferedReader(new InputStreamReader(response.getEntity().getContent()));
            String responseString = "";
            while ((output = br.readLine()) != null) {
                responseString = responseString + output;
            }
            System.out.println("Response string HTTP REquest to URL " + url + "\n response string: \n " + responseString);
            httpClient.close();
            return responseString;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new PluginException(PluginException.PluginErrorCode.UNKNOWN, PluginException.PluginErrorCode.UNKNOWN.getMessage(), e);
        }
    }

    public static String sendPostRequest(String url, String data, String contentType, HashMap headers) {
        try {
            CloseableHttpClient httpClient = HttpUtils.getHttpClient();
            HttpPost postRequest = new HttpPost(url);
            if (headers != null) {
                Iterator iterator = headers.entrySet().iterator();
                if (!headers.isEmpty()) {
                    while (iterator.hasNext()) {
                        Map.Entry pairs = iterator.next();
                        postRequest.setHeader(pairs.getKey().toString(), pairs.getValue().toString());
                    }
                }
            }
            System.out.println("JSON Input: " + data);
            StringEntity input = new StringEntity(data);
            input.setContentType(contentType);
            postRequest.setEntity((HttpEntity)input);
            System.out.println("Sending HTTP Request to URL " + url);
            System.out.println("postRequest :  " + postRequest);
            CloseableHttpResponse response = httpClient.execute((HttpUriRequest)postRequest);
            System.out.println("Response for HTTP Request to URL " + url + " response: " + response.toString() + " \n status code: " + response.getStatusLine().getStatusCode());
            if (response.getEntity() != null) {
                String output;
                System.out.println("response entity not null");
                BufferedReader br = new BufferedReader(new InputStreamReader(response.getEntity().getContent()));
                String status = "";
                while ((output = br.readLine()) != null) {
                    status = status + output;
                }
                System.out.println("Response string HTTP Request to URL " + url + "\n response string: \n " + status);
                httpClient.close();
                return status;
            }
            System.out.println("Response string HTTP Request to URL " + url + "\n response string: \n " + response.toString());
            httpClient.close();
            return response.toString();
        }
        catch (Exception e) {
            throw new PluginException(PluginException.PluginErrorCode.UNKNOWN, e.getMessage(), e);
        }
    }

    private static CloseableHttpClient getHttpClient() throws KeyStoreException, NoSuchAlgorithmException, KeyManagementException {
        HttpClientBuilder builder = HttpClientBuilder.create();
        SSLContext sslContext = new SSLContextBuilder().loadTrustMaterial(null, (arg0, arg1) -> true).build();
        SSLConnectionSocketFactory sslConnectionFactory = new SSLConnectionSocketFactory(sslContext, SSLConnectionSocketFactory.ALLOW_ALL_HOSTNAME_VERIFIER);
        builder.setSSLSocketFactory((LayeredConnectionSocketFactory)sslConnectionFactory);
        Registry registry = RegistryBuilder.create().register("https", (Object)sslConnectionFactory).build();
        BasicHttpClientConnectionManager ccm = new BasicHttpClientConnectionManager((Lookup)registry);
        builder.setConnectionManager((HttpClientConnectionManager)ccm);
        SystemDefaultRoutePlanner routePlanner = new SystemDefaultRoutePlanner(ProxySelector.getDefault());
        CloseableHttpClient httpclient = HttpClients.custom().setRoutePlanner((HttpRoutePlanner)routePlanner).setConnectionManager((HttpClientConnectionManager)ccm).build();
        return httpclient;
    }
}

