/**
 * Watch button interface.
 *
 * Wire up an existing button:
 *
 * var watch = new Watch({el: el});
 * where el is an element that is a result of rendering the watch button soy template.
 *
 * OR
 *
 * Create a new watch button based on the passed in option object (not implemented yet):
 *
 * var watch = new Watch({
 *  isWatching: true|false,
 *  type: "question" | "topic"
 *  id: 1234
 * });
 *
 * watch.render();
 *
 */
define("cq/widget/watch",
    [
        "jquery",
        "cq/util/events",
        "cq/util/analytics",
        "cq/widget/watch-view",
        "cq/widget/watch-model"
    ],
    function (
        $,
        events,
        analytics,
        WatchView,
        WatchModel) {

        function Watch(options) {
            var el = options.el;
            if (el) {
                var $el = $(el);
                options.isWatching = $el.data("is-watching");
                options.id = $el.data("id");
                options.type = $el.data("type");
                delete options.el; // don't pass el to the model.
            }

            var model = new WatchModel(options);
            var view = new WatchView({model: model, el: el});

            // analytics
            model.on("change:isWatching", function (model, isWatching) {
                analytics.trackEvent(model.get("type"), isWatching ? "watch" : "unwatch");
            });

            return {
                model: model,
                view: view,
                render: function() {
                    return view.render();
                }
            }
        }

        return Watch;
    });