define("cq/widget/watch-model",
    [
        "jquery",
        "backbone",
        "cq/util/events"
    ],
    function (
        $,
        Backbone,
        events) {

        return Backbone.Model.extend({
            pathForType: function() {
                var type = this.get("type");
                var id = this.get("id");
                var mapping = {
                    question: "questions/" + id + "/watch",
                    topic: "topic/" + id + "/watch",
                    global: "questions/watch",
                    space: "space/" + id + "/watch"
                };

                return mapping[type];
            },

            url: function() {
                var path = this.pathForType();
                return AJS.contextPath() + "/rest/questions/1.0/" + path;
            },

            toggleWatch: function() {
                var self = this;
                var isWatching = this.get("isWatching");

                self.trigger("request", self);
                $.ajax({
                    url: this.url(),
                    type: isWatching ? "DELETE" : "POST",
                    dataType: "json"
                }).done(function() {
                    self.trigger("sync", self);
                }).error(function() {
                    self.set("isWatching", isWatching);
                    self.trigger("error", self);
                });

                this.set("isWatching", !isWatching);
            }
        });
    });
