require([
    "jquery",
    "cq/util/analytics",
    "cq/widget/topics-list-view",
    "cq/widget/topics-edit-view",
    "cq/widget/topics-model"
], function (
        $,
        analytics,
        TopicsListView,
        TopicsEditView,
        TopicsModel) {

    function initEditableTopics() {

        $(".cq-inline-topics.cq-editable").each(function() {
            var $this = $(this);
            var id = $this.data("content-id");
            var $topicsElement = $this.find("input[name=topics]");

            var topicsModel = new TopicsModel({
                id: id,
                topics: $topicsElement.val()
            });

            var topicsListView = new TopicsListView({
                el: $this.find(".cq-topic-list"),
                model: topicsModel
            });

            var topicsEditView = new TopicsEditView({
                el: $topicsElement,
                model: topicsModel
            });

            // wire up views with model
            topicsListView.on("edit", function () {
                topicsModel.getTopics();
            });

            topicsEditView.on("hide", function () {
                topicsListView.show();
            });

            topicsModel.on("sync:topics", function (model, suggestedTopics) {
                topicsEditView.render(suggestedTopics)
            });
        })

    }

    $(initEditableTopics);
});