define("cq/widget/statistics",
[
    "jquery",
    "cq/widget/loading",
    "ajs",
    "exports"
], function (
    $,
    loading,
    AJS,
    exports) {

    function getQuestionTotal(param) {
        return $.ajax({
            url: AJS.contextPath() + "/rest/questions/1.0/questions/count" + param,
            type: "GET",
            cache: false,
            dataType: "json"
        });
    }

    function getAnswerTotal(param) {
        return $.ajax({
            url: AJS.contextPath() + "/rest/questions/1.0/answers/count" + param,
            type: "GET",
            cache: false,
            dataType: "json"
        });
    }

    function renderErrorMessage() {
        $(".cq-statistics-details").hide().html(CQ.Templates.widget.statistics.errorMessage()).fadeIn(400);
    }

    exports.onReady = function(topicId, spaceKey) {
        $(function() {
            var param = !!topicId ? "?topicId=" + topicId : "?spaceKey=" + spaceKey;
            var sectionSpinner = new loading.SectionSpinner($(".cq-statistics-details"), "cq-statistics-loading-indicator");
            sectionSpinner.show();
            var questionTotalDfd = getQuestionTotal(param);
            var answerTotalDfd = getAnswerTotal(param);
            $.when(questionTotalDfd, answerTotalDfd).done(function(questionsCount, answersCount) {
                sectionSpinner.hide();
                $(".cq-statistics-details").hide().append(
                        $(CQ.Templates.widget.statistics.questionAndAnswerTotals(
                                {
                                    questionsCount: questionsCount[0],
                                    answersCount: answersCount[0]
                                }
                        ))
                ).fadeIn(400)
            }).fail(function() {
                sectionSpinner.hide();
                renderErrorMessage();
            });
        });
    };
});
