define("cq/widget/spacewatchers",
[
    "jquery",
    "cq/widget/loading",
    "ajs",
    "exports"
], function (
    $,
    loading,
    AJS,
    exports) {

    function getSpaceWatchers() {
        var spaceKey = AJS.Meta.get("space-key");
        return $.ajax({
            url: AJS.contextPath() + "/rest/questions/1.0/space/" + spaceKey + "/watch?limit=12",
            type: "GET",
            cache: false,
            dataType: "json"
        });
    }

    function renderSpaceWatchers(spaceWatchers) {
        $(".cq-space-watchers-container").hide().html(CQ.Templates.widget.spaceWatcherAvatars({spaceWatchers: spaceWatchers})).fadeIn(400);
    }

    function renderErrorMessage() {
        $(".cq-space-watchers-container").hide().html(CQ.Templates.widget.spaceWatchersErrorMessage()).fadeIn(400);
    }

    exports.onReady = function() {
        $(function() {
            var sectionSpinner = new loading.SectionSpinner($(".cq-space-watchers-container"), "cq-space-watchers-loading-indicator");
            var spaceWatchersDeferred = getSpaceWatchers();
            sectionSpinner.showUntilResolved(spaceWatchersDeferred);
            spaceWatchersDeferred.done(renderSpaceWatchers).fail(renderErrorMessage);
        });
    };
});
