define("cq/widget/spacepicker",
    [
        "jquery",
        "underscore",
        "backbone",
        "aui-select2",
        "confluence-spacepicker",
        "cq/widget/tooltips",
        "ajs"
    ],
    function (
        $,
        _,
        Backbone,
        auiSelect2,
        ConfluenceSpacePickerOptionsBuilder,
        tooltips,
        AJS) {

        return function (target, defaultString) {

            function SpacePicker(target, defaultString) {
                var self = this;

                this.target = $(target);

                var id = target.attr("id");
                if (!id) {
                    throw new Error("target must have an id attribute");
                }

                var defaults = ConfluenceSpacePickerOptionsBuilder.build();
                var options = $.extend(defaults, {
                    placeholder: defaultString,
                    width: 200,
                    allowClear: true,
                    multiple: false ,
                    initSelection: function(element, callback) { //Override initSelection() because of CONFDEV-31673
                        var spaceKey = element.val();

                        if (spaceKey) {
                            var dfd = $.getJSON(AJS.contextPath() + "/rest/prototype/1/space/" + encodeURI(spaceKey));
                            dfd.done(
                                function(space) {
                                    callback({id: space.key, text: AJS.escapeHtml(space.name)});
                                }
                            );
                        }
                    }
                });

                auiSelect2.call(this.target, options);

                this.getContainer = function() {
                    var container = auiSelect2.call(target, "container");

                    if (!(container instanceof $)) {
                        container = $(container);
                    }

                    return container;
                };

                this.target
                    .on("change", function (e) {
                        if (e.val === "") {
                            return;
                        }

                        $(".cq-spacepicker-status").removeClass("aui-iconfont-unlocked").addClass("aui-iconfont-locked");
                        self.trigger("change", e.val);
                    })
                    .on("select2-removed", function () {
                        $(".cq-spacepicker-status").removeClass("aui-iconfont-locked").addClass("aui-iconfont-unlocked");
                        self.trigger("change", "");
                    });

                if (typeof $.fn.tipsy === "function") {
                    $(".cq-spacepicker-status").tipsy(_.extend({}, tooltips.DEFAULTS, {
                        trigger: 'hover',
                        title: function () {
                            return $(this).hasClass("aui-iconfont-locked") ?
                                    AJS.I18n.getText('cq.space.picker.status.locked.tooltip') :
                                    AJS.I18n.getText('cq.space.picker.status.unlocked.tooltip')
                        },
                        html: true
                    }));

                    $(".select2-search-choice-close").tipsy(_.extend({}, tooltips.DEFAULTS, {
                        trigger: 'hover',
                        title: function () {
                            return AJS.I18n.getText('cq.space.picker.reset.tooltip');
                        }
                    }));
                }
            }

            _.extend(SpacePicker.prototype, Backbone.Events);

            return new SpacePicker(target, defaultString);
        };
    }
);
