define("cq/widget/sidebarstatistics",
[
    "jquery",
    "cq/util/analytics",
    "cq/widget/loading",
    "ajs",
    "exports"
], function (
    $,
    analytics,
    loading,
    AJS,
    exports) {

    function getDetailedExpert() {
        return $.ajax({
            url: AJS.contextPath() + "/rest/questions/1.0/experts/reputation",
            type: "GET",
            cache: false,
            dataType: "json",
            data: {
                username: AJS.Meta.get("remote-user")
            }
        });
    }

    function renderDetailedExpert(expert) {
        $(".cq-sidebar-statistics").data("username", expert.expert.name);
        $(".cq-your-statistics-container").hide().html(CQ.Templates.widget.detailedExpert({expert: expert})).fadeIn(400);
    }

    function renderErrorMessage() {
        $(".cq-your-statistics-container").hide().html(CQ.Templates.widget.yourStatisticsErrorMessage()).fadeIn(400);
    }

    exports.onReady = function() {
        $(function() {
            var sectionSpinner = new loading.SectionSpinner($(".cq-your-statistics-container"), "cq-expert-statistics-loading-indicator");
            var expertDfd = getDetailedExpert();
            sectionSpinner.showUntilResolved(expertDfd);
            expertDfd.done(renderDetailedExpert).fail(renderErrorMessage);
        });
    };
});