require([
    "jquery",
    "underscore",
    "cq/widget/notifications",
    "cq/util/analytics"
], function(
        $,
        _,
        notifications,
        analytics) {

    function makeInstabanDialog(userKey, fullName) {

        var dialog = new AJS.Dialog({
            width: 500,
            height: 200,
            id: "cq-instaban-dialog",
            closeOnOutsideClick: true
        });

        dialog.addHeader(AJS.I18n.getText("cq.instaban.dialog.title", fullName));
        dialog.addPanel("Panel 1", '<p>' + AJS.I18n.getText("cq.instaban.dialog.body") + '</p>',
                "panel-body");

        dialog.addButton("Confirm", function (dialog) {

            $.ajax({
                url: AJS.contextPath() + "/rest/questions/1.0/spam/instaban/" + userKey,
                type: "POST",
                dataType: "json"
            }).done(function () {
                analytics.trackEvent("profilelist", "instaban");

                notifications.notify({
                    type: "success",
                    title: AJS.I18n.getText("cq.instaban.dialog.notification.success.title"),
                    body: AJS.I18n.getText("cq.instaban.dialog.notification.success.body", fullName)
                });

            }).error(function (jqXhr) {

                if (jqXhr.status >= 400) {
                    var error = JSON.parse(jqXhr.responseText);

                    notifications.notify({
                        type: "warning",
                        title: AJS.I18n.getText("cq.instaban.dialog.notification.failure.title", fullName),
                        body: error.message
                    });
                }


            });

            dialog.remove();


        });
        dialog.addLink("Cancel", function (dialog) {
            dialog.hide();
        }, "#");

        return dialog;
    }


    function initInstabanDialog() {
        var $trigger = $(".cq-instaban-button");
        $trigger.click(function() {
            var userkey = $(this).data("userkey");
            var fullName = $(this).data("fullname");
            var dialog = makeInstabanDialog(userkey, AJS.escapeHtml(fullName));
            dialog.show();

        });
    }

    $(function() {
        initInstabanDialog();
    })

});
