define("cq/widget/notifications",
    [
        "jquery",
        "underscore",
        "exports",
        "ajs-messages"
    ],
    function (
        $,
        _,
        exports,
        messages) {

        var DEFAULTS = {
            type: "info",
            duration: 5,
            position: "top",
            fadeIn: false
        };

        var POSITIONS = {
            'top' : {
                container: 'cq-notifications-container-top',
                insert: 'append'
            },
            'bottom-right' : {
                container: 'cq-notifications-container-bottom-right',
                insert: 'prepend'
            }
        };

        $(function() {
            // add containers to DOM
            _.each(POSITIONS, function (value) {
                var $container = $("<div></div>", {id: value.container}).addClass("cq-notifications-container");
                $("body").append($container);
            });
        });

        /**
         * Shows a notification.
         *
         * @param options
         *  type -  the type [info, warning, success, error]
         *  title - the title
         *  body - the body
         *  duration - duration in seconds (defaults to 5 seconds)
         *  position - where to show the notification [top, bottom-right]
         *
         *  @return the message jQuery object
         */
        exports.notify = function (options) {
            options = _.extend({}, DEFAULTS, options);

            var position = POSITIONS[options.position];
            if (! position) {
                console.error("[ERROR] cq/widget/notifications: Unknown position parameter");
            }

            var $message = messages[options.type]("#" + position.container, {
                title: options.title,
                body: options.body,
                closeable: true,
                insert: position.insert
            });

            if (options.fadeIn) {
                $message.hide().fadeIn("fast");
            }

            if (options.errorKey) {
                $message.attr("data-error-key", options.errorKey);
            }

            setTimeout(function () {
                $message.fadeOut("fast", function () {
                    $(this).closeMessage();
                });
            }, options.duration * 1000);

            return $message;
        };
    });