define("cq/widget/notifications-checker",
    [
        "jquery",
        "underscore",
        "cq/widget/notifications",
        "exports"
    ],
    function (
            $,
            _,
            notifications,
            exports) {

        function checkNotification() {
            var rawNotification = AJS.Meta.get("cq-notification");
            if (!rawNotification) {
                return;
            }

            try {
                var notification = JSON.parse(rawNotification);

                notifications.notify({
                    type: notification.type,
                    title: notification.title,
                    duration: 7,
                    fadeIn: true
                });
            } catch (e) {
                console.error("Error parsing notification", e);
            }
        }

        exports.init = checkNotification;
    });


// init everywhere
require(["jquery", "cq/widget/notifications-checker"], function ($, notificationsChecker) {
    $(notificationsChecker.init);
});
