define("cq/widget/loading",
    [
        "jquery",
        "underscore",
        "exports"
    ],
    function (
        $,
        _,
        exports) {

        var SpinPresets = {
            "small": { lines: 12, length: 3, width: 2, radius: 3, trail: 60, speed: 1.5 },
            "medium": { lines: 12, length: 5, width: 3, radius: 8, trail: 60, speed: 1.5 },
            "large": { lines: 12, length: 8, width: 4, radius: 10, trail: 60, speed: 1.5 }
        };

        var PageLoadingIndicator = (function () {
            function getBlanket() {
                return $("#cq-page-loading-blanket");
            }

            function getIndicator() {
                return $("#cq-page-loading-blanket .cq-loading-indicator");
            }

            return {
                show: function () {
                    if (getBlanket().length === 0) {
                        $("body").append(CQ.Templates.widget.loading.pageLoadingIndicator());
                    }

                    getBlanket().show();
                    getIndicator().spin(_.extend({}, SpinPresets.medium, {color: "#F0F0F0"}));
                },

                hide: function() {
                    getIndicator().stop();
                    getBlanket().hide();
                },

                showUntilResolved: function(dfd) {
                    this.show();
                    dfd.always(_.bind(this.hide, this));
                }
            }
        }());

        /**
         * Shows a loading spinner for a given section/element.
         *
         * @param $section
         */
        var SectionSpinner = function($section, cssClass) {
            function getBlanket() {
                return $(".cq-section-loading-blanket", $section);
            }

            function getIndicator() {
                return $(".cq-loading-indicator", $section);
            }

            return {
                show: function () {
                    if (getBlanket().length === 0) {
                        var $sectionLoadingIndicator = $(CQ.Templates.widget.loading.sectionLoadingIndicator());
                        if (!!cssClass) {
                            $sectionLoadingIndicator.addClass(cssClass);
                        }
                        $($section).append($sectionLoadingIndicator);
                    }

                    getBlanket().show();
                    getIndicator().spin(_.extend({}, SpinPresets.medium));
                },

                hide: function() {
                    getIndicator().stop();
                    getBlanket().hide();
                },

                showUntilResolved: function(dfd) {
                    this.show();
                    dfd.always(_.bind(this.hide, this));
                },

                destroy: function() {
                    $section.remove(".cq-section-loading-blanket");
                }
            }
        };

        exports.SpinPresets = SpinPresets;

        exports.getPageLoadingIndicator = function() {
            return PageLoadingIndicator;
        };

        exports.SectionSpinner = SectionSpinner;
    });