define("cq/widget/filters", ["jquery", "underscore", "backbone", "exports"], function ($, _, Backbone, exports) {
    function Filters() {
        var self = this;

        // set pressed state on click
        $(".cq-filters a").on("click", function (e, data) {

            var $this = $(this);
            var filter = $this.data("filter");
            var href = $this.attr("href");

            var button = $this.closest("li");
            button.siblings().attr("aria-pressed", "false");
            button.attr("aria-pressed", "true");

            $.cookie("cq.questions.filter", filter);

            if (!data || !data.silent) {
                self.trigger("change", filter, href, e);
            }
        });

        this.setFilter = function(filter) {
            $(".cq-filters [data-filter='" + filter + "']").trigger("click", {
                silent: true
            });
        };

        this.getActiveFilter = function () {
            return $(".cq-filters li[aria-pressed='true'] a").attr("data-filter");
        };
    }
    _.extend(Filters.prototype, Backbone.Events);

    return new Filters();
});