define("cq/widget/editor",
        [
            "jquery",
            "backbone",
            "underscore",
            "cq/widget/editor/toolbar",
            "cq/util/events",
            "cq/util/analytics",
            "cq/widget/loading"
        ],
        function (
            $,
            BackBone,
            _,
            toolbar,
            events,
            analytics,
            loadingUtil) {

            var editor = BackBone.View.extend({
                el: ".cq-editor-wrapper",
                initialize: function (options) {
                    this.el = options.el;
                    this.$container = options.$container;
                    AJS.bind("rte-quick-edit-ready", _.bind(function () {
                        this.fixEditorFocus();
                        this.setMacroBrowserWhitelist();
                        this.focusErrorInput();
                    }, this));
                    this.type = options.type;
                    AJS.Meta.set("cq-editor-type", this.type);
                    _.bindAll(this, '_createEditorDone', '_createEditorFailed');
                },
                createEditor: function () {
                    $(".cq-editor-wrapper .cq-editor-body").empty();
                    $(".cq-editor-wrapper .cq-editor-prompt").show();

                    // blacklisted: table,insertwikimarkup,dfe,pagelayoutplugin,confluencetasklist
                    var enabledPlugins = "auiwindowmanager,emotions,confluence,macroplaceholder,customtoolbar,propertypanel," +
                            "keyboardshortcuts,confmonospace,confcharmap,lists,confluencepaste,cursorTarget,confluencecleanupplugin," +
                            "conftable,confluencepastetableplugin,confluencepastemacroplugin,showformat,highlightnode,iosediting," +
                            "searchreplace,autoconvert,confluencelist,deletecommand,draggable,confluencesortabletablesplugin," +
                            "textplaceholders,autoresize,jiraconnector,insertmention,linkbrowser,autocomplete,autocompletelink," +
                            "autocompletemedia,autocompletemacro,dateautocomplete";

                    var content = $(".cq-editor-content", this.$container) ? $(".cq-editor-content", this.$container).val() : "";

                    var quickEditDfd = AJS.CQ.QuickEdit.activateEditor({
                        $container: this.$container,
                        saveHandler: function () {},
                        cancelHandler: function () {},
                        closeAnyExistingEditor: true,
                        content: {editorContent: content},
                        postDeactivate: function () {},
                        plugins: enabledPlugins
                    });
                    var sectionSpinner = new loadingUtil.SectionSpinner(this.$container, "cq-editor-loading-indicator");
                    sectionSpinner.showUntilResolved(quickEditDfd);
                    var that = this;
                    quickEditDfd.done(function() {
                        that._createEditorDone();
                        toolbar.onReady();
                    }).fail(this._createEditorFailed);
                },
                _createEditorDone: function() {
                    this.hideUnwantedItems();
                    this.trackAnalytics();
                    AJS.trigger("cq-editor-ready", this.type); // this event will be triggered only when all deferred object are resolved
                    console.log("**** The quick editor must be created successfully! Event cq-editor-ready was triggerred!!! ")
                },
                _createEditorFailed: function() {
                    this.$container.find(".cq-editor-message-error").removeClass("hidden");
                    this.$container.find("#fallBackUrl").attr("href", window.location.href);
                    AJS.log("Fail to load Editor");
                },
                /**
                 * transfer editorContent to #wysiwygTextarea hidden filed
                 */
                saveContent: function () {
                    if (tinyMCE.activeEditor) {
                        tinyMCE.activeEditor.save();
                    } else {
                        AJS.log("There is no tinyMCE active editor this time");
                    }
                },
                /**
                 * Remove some buttons from the editor toolbar.
                 */
                hideUnwantedItems: function () {
                    $("#rte-toolbar #insert-table-dropdown").closest(".aui-buttons").remove();
                    $("#rte-toolbar #color-picker-control").remove();
                    $("#rte-toolbar #rte-button-outdent").closest(".aui-buttons").remove();
                    $("#rte-toolbar #rte-button-justifyleft").closest(".aui-buttons").remove();
                    $("#rte-toolbar #insert-menu").closest(".aui-buttons").hide(); // hide, don't remove. otherwise editor breaks
                    $("#rte-toolbar #rte-button-undo").closest(".aui-buttons").remove();
                    $("#rte-toolbar #rte-button-link").closest(".aui-buttons").remove();
                    $("#rte-toolbar #rte-button-help").closest(".aui-buttons").remove();
                    $("#rte-toolbar .rte-toolbar-group-files").remove();
                    $("#rte-toolbar #rte-button-searchreplace").remove();
                    $("#rte-toolbar .aui-toolbar2-secondary").remove();

                    $("#insert-menu-options .content-image").remove();
                    $("#insert-menu-options .content-attachment").remove();
                    $("#insert-menu-options .content-wikimarkup").remove();
                    $("#insert-menu-options .content-macro").remove();
                },
                /**
                 * All buttons have some id associated with them. Either it's on the li or the anchor. Track the usage of clicking
                 * these buttons.
                 */
                trackAnalytics: function () {
                    $("#toolbar").on("click", "li, a", function () {
                        if ($(this).attr("id")) {
                            analytics.trackClick(this, "editor");
                        }
                    })
                },

                setMacroBrowserWhitelist: function () {
                    AJS.MacroBrowser.setWhitelist("code,warning,info,tip,note");
                    AJS.MacroBrowser.preLoadMacro();
                },
                /**
                 * Fix Chrome (30) / IE11 bug where you only get focus if you click the first line. Doesn't hurt to set these
                 * attributes on all browsers to avoid user agent sniffing.
                 */
                fixEditorFocus: function () {
                    var $editorFrame = $(AJS.Rte.getEditorFrame());
                    $editorFrame.contents().find("html").css("height", "100%");
                    $editorFrame.contents().find("body").css("min-height", "100%");
                },
                focusErrorInput : function () {
                    if (($("form.aui .warning").length == 1 && $("form.aui .warning").is("#captcha-error"))) {
                        setTimeout(function () {
                            $("#captcha-response").focus();
                        }, 500); // wait for 0.5 to avoid race condition

                    } else {
                        $("#cq-question-title").focus().val($("#cq-question-title").val());
                    }
                }
            }
        );
        return editor;
    }
);
