(function($){


    function initGlobalBlueprint() {
        var BLUEPRINT_KEY = "com.atlassian.confluence.plugins.confluence-questions:ask-a-question-blueprint-webitem";

        Confluence.Blueprint.setDirectCallback(BLUEPRINT_KEY, function(e, state) {
            state.finalUrl = Confluence.getContextPath() + "/questions/ask?src=createdialog";
        });

        function disableSpaceSelect(e, data) {
            var config;
            if (data) {
                if (data.config) {
                    config = data.config;
                } else if (data.item) {
                    config = data.item.data();
                }
            }
            var blueprintModuleCompleteKey = config && config.itemModuleCompleteKey || null;
            $(".create-dialog-body .space-select").select2("enable", blueprintModuleCompleteKey !== BLUEPRINT_KEY);

        }
        AJS.bind(Confluence.Dialogs.Events.ITEM_SELECTED, disableSpaceSelect);

    }

    function initSpaceBlueprint() {
        var BLUEPRINT_SPACE_KEY = "com.atlassian.confluence.plugins.confluence-questions:ask-a-space-question-blueprint-webitem";

        Confluence.Blueprint.setDirectCallback(BLUEPRINT_SPACE_KEY, function(e, state) {
            state.finalUrl = Confluence.getContextPath() + "/display/" + state.spaceKey + "/questions/ask?src=createdialog";
        });
    }

    initGlobalBlueprint();
    initSpaceBlueprint();

}(AJS.$));