
define("cq/util/autosave",
        [
            "jquery",
            "underscore",
            "backbone",
            "cq/widget/notifications",
            "cq/editor/autosave/indicator",
            "cq/util/util",
        ],
        function (
                $,
                _,
                Backbone,
                notification,
                Indicator,
                util) {

            var _getURLParameter=  function (name) {
                return decodeURIComponent((new RegExp('[?|&]' + name + '=' + '([^&;]+?)(&|#|;|$)').exec(location.search)||[,""])[1].replace(/\+/g, '%20'))||null
            };

            var _showDraftMessage = function(opts){
                if (_getURLParameter('draftId') !== null)
                    return;

                var lastDraftId = opts.lastDraftId;
                if (lastDraftId && "" !== lastDraftId){
                    var numberOfShow = util.getItem(opts.draftStoreKey + "-show-times");
                    numberOfShow  = parseInt(numberOfShow);
                    if (numberOfShow < 2) {
                        notification.notify({
                            type: "warning",
                            body: CQ.Templates.widget.draftLink({
                                draft: {
                                    url: AJS.contextPath() + opts.reloadUrl + lastDraftId,
                                }})
                        });

                        util.setItem(opts.draftStoreKey + "-show-times", ++numberOfShow);
                    } else {
                        util.setItem(opts.draftStoreKey + "-show-times", 0);
                    }
                }
            };

            var _attachToEditor = function(opts){
                var latestContent;
                AJS.Rte.BootstrapManager.addOnInitCallback(function () {
                    var editor = AJS.Rte.getEditor();

                    editor.onChange.add(function () {
                        if (editor.isDirty() || latestContent) {
                            latestContent = editor.getContent();
                            AJS.log("Editing content change detected save latest value");
                            AJS.log(latestContent);
                        }
                    });
                });

                setInterval(function(){
                    var draftData = opts.dataExtractor(latestContent);

                    if (draftData && latestContent) {
                        if (!opts.editorIndicator) {
                            opts.editorIndicator =  new Indicator({el: '#draft-status'});
                        }

                        saveDraft(opts.draftStoreKey, opts.draftId);
                        $.ajax({
                            type: "PUT",
                            url: AJS.contextPath() + opts.saveUrl + opts.draftId,
                            contentType: "application/json",
                            dataType: "json",
                            data: JSON.stringify(draftData),
                            success: function (draft) {
                                latestContent = undefined;
                                AJS.log("Draft data for question was saved successful");
                            },
                            error: function (xhr, ajaxOptions, thrownError){
                                opts.editorIndicator.showErrorIndicator();
                            }
                        });
                        util.setItem(opts.draftStoreKey + "-show-times", 0);
                    }

                }, opts.pollingInterval * 1000);
            };

            var saveDraft = function(draftStoreKey, draftId) {
                if (draftId){
                    util.setItem(draftStoreKey, draftId);
                }
            };

            var initAutoSave = function (options) {

                var defaultOptions = {
                    draftId: null,
                    saveUrl: null,
                    reloadUrl: null,
                    draftStoreKey: null,
                    $saveForm: null,
                    dataExtractor: function () {},
                    pollingInterval: 45
                };

                var opts = $.extend({}, defaultOptions, options);

                if (!opts.draftId ||
                        !opts.saveUrl ||
                        !opts.reloadUrl ||
                        !opts.draftStoreKey ||
                        !opts.$saveForm
                ) {
                    // do nothing in this case
                    return;
                }

                opts.lastDraftId = util.getItem(opts.draftStoreKey);
                _showDraftMessage(opts);
                _attachToEditor(opts);

                // clean draft id if user already retrieve it
                $(".cq-draft-name").on("click", function(){
                    util.setItem(opts.draftStoreKey, "");
                });
                // Or clean draft if the form is submitted
                opts.$saveForm.submit(function(){
                    util.setItem(opts.draftStoreKey, "");
                });
            };

            return {
                initAutoSave : initAutoSave,
                saveQuestionDraftId : saveDraft
            }
        });