require( [
        "jquery",
        "cq/util/events",
        "cq/util/analytics"
    ],
    function (
        $,
        events,
        analytics) {

        var labelsByType = {
            "vote" : {
                title: AJS.I18n.getText("cq.anonymous.dialog.vote.title"),
                body:AJS.I18n.getText("cq.anonymous.dialog.vote.body")
            },
            "comment" : {
                title: AJS.I18n.getText("cq.anonymous.dialog.comment.title"),
                body:AJS.I18n.getText("cq.anonymous.dialog.comment.body")
            },
            "watch" : {
                title: AJS.I18n.getText("cq.anonymous.dialog.watch.title"),
                body:AJS.I18n.getText("cq.anonymous.dialog.watch.body")
            },
            "ask" : {
                title: AJS.I18n.getText("cq.anonymous.dialog.ask.title"),
                body:AJS.I18n.getText("cq.anonymous.dialog.ask.body")
            }
        };

        function makeDialog($el) {
            var type = $el.data("anonymous-restricted");

            analytics.trackEvent("anonymous", type);

            // We don't want to show the tooltip while the dialog is open
            $el.tipsy("hide");
            $el.tipsy('disable');

            var options = {
                noBind: true,
                offsetX: -20,
                width: 250,
                hideCallback: function() {
                    $el.tipsy('enable');
                }
            };

            var labels = labelsByType[type];

            var dialog = AJS.InlineDialog($el, "anonymous-" + type + "-dialog", function(content, trigger, showPopup) {
                content.html(CQ.Templates.widget.loginOrSignupDialog({
                    title: labels.title,
                    body: labels.body,
                    publicSignupPermitted: AJS.Meta.get("public-signup-permitted"),
                    loginRedirect: encodeURIComponent(document.location.pathname.replace(AJS.contextPath(), ""))
                }));

                showPopup();
            }, options);

            return dialog;
        }

        $(function () {
            if (!AJS.Meta.get("remote-user")) {
                $("[data-anonymous-restricted]").each(function () {
                    var $el = $(this);

                    // Remove existing event handler
                    $el.unbind("click");
                    var dialog = makeDialog($el);

                    $el.on("click", function(e) {
                        dialog.show();

                        e.stopImmediatePropagation();
                        return false;
                    })
                });
            }
        });
    });