define("cq/widget/accept",
    [
        "jquery",
        "underscore",
        "cq",
        "cq/api/question-service",
        "cq/widget/tooltips",
        "cq/util/analytics"
    ],
    function (
        $,
        _,
        CQ,
        questionService,
        tooltips,
        analytics) {

        var AcceptIconView = CQ.View.extend({
            events: {
                "click": "toggleAccepted"
            },

            initialize: function() {
                this.model.on("change:accepted", function (model, accepted) {
                    this.$el.attr("data-accepted", accepted);
                }, this);

                this.observeAjaxRequests("accepted");

                this.initializeTooltip();
            },

            initializeTooltip: function() {
                var self = this;
                var options = _.extend({}, tooltips.DEFAULTS, {
                    trigger: 'hover',
                    title: function () {
                        return self.model.get("accepted") ?
                            AJS.I18n.getText('cq.question.answer.accepted.tooltip') :
                            AJS.format(AJS.I18n.getText('cq.question.answer.accept.tooltip'), self.model.get("author").fullName);
                    },
                    html: true
                });

                this.$el.tipsy(options);

                this.$el.on("click", _.bind(function () {
                    this.$el.tipsy("hide");
                }, this));
            },

            render: function() {
                return this;
            },

            toggleAccepted: function(e) {
                e.preventDefault();
                analytics.trackEvent("answer", "accept-icon-click");
                this.model.toggleAccepted();
            }
        });

        function AcceptIconButton(options) {
            var $el = $(options.el);
            var answerId = $el.data("answer-id");

            return {
                render: function () {
                    questionService.getAnswer(answerId).done(function (answer) {
                        var view = new AcceptIconView({
                            model: answer,
                            el: options.el
                        });

                        view.render();
                    });
                }
            }
        }

        return AcceptIconButton;
    });