define("cq/util/routes", ["jquery", "underscore", "ajs", 'url-template', "exports"], function($, _, AJS, UrlTemplate, exports) {

    // Don't forget to modify the mapping in ActionRouter.java if you modify it here
    var routeMapping = {
        "askquestion": "/ask",
        "viewquestion": "/{questionId}",
        "questions": {
            "GLOBAL": "",
            "SPACE": "/all"
        }
    };

    function getRouteContext(context) {
        if (context !== undefined) {
            var spaceKey = context["spaceKey"];
            if (spaceKey !== undefined) {
                return "SPACE";
            }
        }

        return "GLOBAL";
    }

    function getPrefix(context) {
        if (context !== undefined) {
            var spaceKey = context["spaceKey"];
            if (spaceKey !== undefined) {
                return "/display/" + spaceKey + "/questions";
            }
        }

        return "/questions";
    }

    function getMapping(action, routeContext) {

        var mapping = routeMapping[action];
        if (_.isString(mapping)) {
            return mapping;
        }

        return mapping[routeContext];
    }

    exports.routeFor = function(action, context) {

        var routeContext = getRouteContext(context);

        var uri = UrlTemplate.parse(getPrefix(context) + getMapping(action, routeContext));

        return uri.expand(context);
    }

});