// Prevent double form submit. Stolen from Stash.
define("cq/util/form", ["jquery", "exports"], function ($, exports) {

    function preventDefault(e) {
        e.preventDefault();
    }

    function setSubmissionPrevented($form, shouldPrevent) {
        $form.data("preventSubmission", shouldPrevent);
        $form.find(":submit").toggleClass("disabled", shouldPrevent).prop("disabled", shouldPrevent);
        $form.find("a, button, input[type='button']")[shouldPrevent ? "on" : "off"]("click", preventDefault).toggleClass("disabled", shouldPrevent);
    }

    exports.preventSubmission = function($form) {
        setSubmissionPrevented($form, true);
    };

    exports.allowSubmission = function($form) {
        setSubmissionPrevented($form, false);
    };

    exports.isSubmissionPrevented = function($form) {
        return $form.data("preventSubmission");
    };

    /**
     * Serializes a form into a JSON object.
     * From: http://stackoverflow.com/questions/17488660/difference-between-serialize-and-serializeobject-jquery
     */
    exports.serializeToJSON = function($form) {
        var o = {};
        var a = $form.serializeArray();
        $.each(a, function() {
            if (o[this.name]) {
                if (!o[this.name].push) {
                    o[this.name] = [o[this.name]];
                }
                o[this.name].push(this.value || '');
            } else {
                o[this.name] = this.value || '';
            }
        });

        return o;
    }

    exports.serializeToJSONString = function($form) {
        return JSON.stringify(this.serializeToJSON($form));
    }
});

// auto bind forms with class cq-prevent-double-submit
require(["cq/util/form", "jquery"], function (form, $) {
    function addUnloadHandlerOnce(func) {
        var $window = $(window);

        // Safari and FF disable caching when using the unload handler, but both support pagehide, so use that instead
        var event = Object.prototype.hasOwnProperty.call(window, "onpagehide") ? "pagehide" : "unload";

        var handler = function() {
            $window.off(event, handler);
            return func.apply(this, arguments);
        };

        $window.on(event, handler);
    }

    // This will prevent double-submit on all forms that are submitted natively (e.g., no AJAXy stuff).
    $(document).on("submit", ".cq-prevent-double-submit", function(e) {
        var $form = $(e.target);

        if (form.isSubmissionPrevented($form)) {
            e.preventDefault();
        } else {
            // We need to ensure we are the last ones to handle this.
            // otherwise some other JS can come later and do a preventDefault, but we"ll think
            // the submit went through and prevent the next submit.
            // We also need to ensure that we don"t affect the current submit when we disable buttons and such.
            // To those ends, we use a setTimeout here.
            setTimeout(function() {
                if (!e.isDefaultPrevented()) {
                    form.preventSubmission($form);

                    addUnloadHandlerOnce(function() {
                        // Firefox and Safari cache page state.  So we have to reenable the buttons before leaving
                        // the page, otherwise the form won"t work after you hit the back button to return.
                        form.allowSubmission($form);
                    });
                }
            }, 0);
        }
    });
});

// provide xsrf token to all forms with class cq-xsrf-token-required on form submit
require(["cq/util/form", "jquery"], function (form, $) {
    $(document).on("submit", ".cq-xsrf-token-required", function(e) {
        var $form = $(e.target);
        if (!$form.data("xsrf-token-provided")) {
            var $hiddenTokenField = $("<input type='hidden' name='atl_token'>").val(AJS.Meta.get("atl-token"));
            $form.append($hiddenTokenField);
            $form.data("xsrf-token-provided", true);
        }
    });
});
