/**
 * Tracks events captured by the server that get output into a meta tag.
 */
require([ "jquery", "underscore", "cq/util/analytics" ], function ($, _, analytics) {
    $(function () {
        var events = AJS.Meta.get("cq-analytics-events");
        if (!events) {
            return;
        }

        _.each(events.split(","), function (event) {
            event = event.split(".");
            var noun = event[0];
            var verb = event[1];

            analytics.trackEvent(noun, verb);
        });
    });
});