define("cq/layout/base",
    [
        "jquery",
        "cq",
        "cq/util/events",
        "cq/util/analytics",
        "exports"
    ],
    function (
        $,
        cq,
        events,
        analytics,
        exports) {

        function initFeedbackButton() {
            // only activate if there's already a issue collector defined (e.g. on EAC)
            if (!window.ATL_JQ_PAGE_PROPS) {
                return;
            }

            window.CQ_version = "2.4.15";
            var getUserName = AJS.Meta.get('remote-user');
            var darkFeatures = AJS.Meta.get('enabled-dark-features');
            var getVersionNumber = AJS.Meta.get('version-number');
            var spaceTheme = document.getElementById("com-atlassian-confluence").className;


            // f6d275a9 - CQ project collector on JAC
            window.ATL_JQ_PAGE_PROPS = window.ATL_JQ_PAGE_PROPS || {};
            window.ATL_JQ_PAGE_PROPS["f6d275a9"] = {
                environment: {
                    "User Name" : getUserName,
                    "Current Dark Features" : darkFeatures,
                    "SpaceTheme" : spaceTheme,
                    "VersionNumber" : getVersionNumber,
                    "CQ Version": cq.VERSION
                },
                fieldValues:{
                    "components":"25694", // CQ - Feedback
                    "security": "10040" // devs and reporter only
                },
                triggerFunction: function(showCollectorDialog) {
                    $("#feedback-menu-link").off("click");
                    $("#feedback-menu-link").click(function (e) {
                        e.preventDefault();
                        e.stopImmediatePropagation();
                        showCollectorDialog();
                    });
                }
            };

            $.ajax({
                url: "https://jira.atlassian.com/s/d41d8cd98f00b204e9800998ecf8427e/en_UK-pztlv2-1988229788/6144/9/1.4.0-m6/_/download/batch/com.atlassian.jira.collector.plugin.jira-issue-collector-plugin:issuecollector-embededjs/com.atlassian.jira.collector.plugin.jira-issue-collector-plugin:issuecollector-embededjs.js?collectorId=f6d275a9",
                type: "get",
                cache: true,
                dataType: "script"
            });
        }

        exports.onReady = function() {
            $(initFeedbackButton);
        };
    });