require([
        "jquery",
        "cq/util/events",
        "cq/util/analytics",
        "cq/widget/notifications"
    ],
    function (
        $,
        events,
        analytics,
        notifications
        ) {


        function showWelcomeDialog() {
            var dialog = new AJS.Dialog({
                width: 840,
                height: 500,
                id: "cq-welcome-dialog"
            });

            dialog.addHeader(AJS.I18n.getText("cq.welcome.title"));
            dialog.addPanel("SinglePanel", CQ.Templates.feature.welcome.welcome());

            dialog.addButton(AJS.I18n.getText("cq.welcome.continue.with.demo.content.button"), function () {
                analytics.trackEvent("welcomedialog", "createdemocontent");

                $(this).attr("disabled", true);

                var createDemoContentDeferred = $.ajax({
                    url: AJS.contextPath() + "/rest/questions/1.0/demo/create" ,
                    type: "POST"
                });

                createDemoContentDeferred.done(function() {
                    dialog.hide();
                    notifications.notify({
                        type: "success",
                        duration: 10,
                        title: AJS.I18n.getText("cq.create.demo.content.success.title"),
                        body: CQ.Templates.feature.welcome.createDemoContentSuccess()
                    });
                    // we need to reIndex by another Ajax request so that
                    // the new content can be visible after committed in the previous transaction
                    var reIndexDeferred = $.ajax({
                        url: AJS.contextPath() + "/rest/questions/1.0/admin/reindex" ,
                        type: "POST"
                    });
                    reIndexDeferred.done(function() {
                        window.location.href = AJS.contextPath() + "/questions/topics";
                    });
                    reIndexDeferred.fail(function(xhr, textStatus, errorThrown) {
                        notifications.notify({
                            type: "error",
                            title: AJS.I18n.getText("cq.create.demo.content.error.title"),
                            body: CQ.Templates.feature.welcome.createDemoContentError({errorMessage: errorThrown})
                        });
                    });
                });

                createDemoContentDeferred.fail(function(xhr, textStatus, errorThrown) {
                    dialog.hide();
                    // show error message
                    notifications.notify({
                        type: "error",
                        title: AJS.I18n.getText("cq.create.demo.content.error.title"),
                        body: CQ.Templates.feature.welcome.createDemoContentError({errorMessage: errorThrown})
                    });
                });

            }, "cq-button-panel-welcome-button");

            dialog.addButton(AJS.I18n.getText("cq.welcome.continue.button"), function(dialog) {

                analytics.trackEvent("welcomedialog", "skipdemocontent");

                $.ajax({
                    url: AJS.contextPath() + "/rest/questions/1.0/demo/skipcreation" ,
                    type: "POST"
                });

                dialog.hide();
            });

            // Primary button
            $(".cq-button-panel-welcome-button").removeClass("button-panel-button").addClass("aui-button aui-button-primary");

            dialog.gotoPage(0);
            dialog.gotoPanel(0);
            dialog.show();
        }

        $(function () {
            if (AJS.Meta.get("cq-show-welcome")) {
                showWelcomeDialog();
            }
        });

    });
