define("cq/feature/viewquestion/answer",
    [
        "jquery",
        "underscore",
        "cq/util/events",
        "cq/util/analytics",
        "cq/util/form",
        "cq/widget/vote",
        "cq/widget/editor",
        "exports"
    ],
    function (
        $,
        _,
        events,
        analytics,
        formUtil,
        Vote,
        Editor,
        exports) {

        var $form;
        var $draftIdInput;
        var draftId;

        var AnswerView = Backbone.View.extend({
            el : ".cq-answerquestion",
            initialize: function (options) {
                this.initNewAnswer();
                AJS.bind("cq-editor-ready", this.handleAnswerEditor);
            },
            initNewAnswer: function () {
                if (AJS.Meta.get("edit-answer") || !AJS.Meta.get("remote-user")) {
                    return;
                }
                $form = $(".cq-answer-form", this.$el);
                $draftIdInput = $form.find("input[name='draftId']");
                this.setupDraft();
            },
            handleAnswerEditor: function (eventName, type) {
                if ("ANSWER" === type) {
                    $(".cq-answer-form .buttons-container").show();
                    $("div[data-answer-editable=true]", $(".cq-answer-container")).addClass("hidden");
                } else {
                    $(".cq-answer-form .error").remove();
                    $(".cq-answer-form .buttons-container").hide();
                    $("div[data-answer-editable=true]", $(".cq-answer-container")).removeClass("hidden");
                }
            },
            setupDraft: function (){
                if (draftId) {
                    return;
                }
                var questionId = AJS.Meta.get("question-id");

                draftId = "pending";
                var dfd = $.ajax({
                    type: "POST",
                    url: AJS.contextPath() + "/rest/questions/1.0/questions/" + questionId + "/answerDrafts",
                    dataType: "json",
                    success: function (draft) {
                        draftId = draft["id"];

                        $draftIdInput.val(draftId);
                        AJS.Meta.set("drag-and-drop-entity-id", draftId);
                        AJS.Meta.set("attachment-source-content-id", draftId);
                        AJS.Meta.set("content-id", draftId);
                    }
                });
                setTimeout(function () {
                    formUtil.preventSubmission($form);
                    dfd.done(function () {
                        formUtil.allowSubmission($form);
                    });
                }, 100);

            },
            createEditor: function () {
                var  editor = new Editor({
                    $container: $(".cq-answer-form .cq-editor-wrapper", this.$el),
                    type: "ANSWER"
                });
                editor.createEditor();
                this.editor = editor;
            }
        });
        return AnswerView;
    });
require(["jquery", "cq/widget/editor","cq/feature/viewquestion/answer"], function ($, Editor,Answer) {
    $(function () {
        $(".cq-answer-form .buttons-container").hide();
        var $editor = $(".cq-editor-wrapper");
        if ($editor.length > 0) {
            $(".cq-answerquestion .cq-editor-prompt").click(function () {
                AJS.trigger("remove-comment-form");
                new Answer().createEditor();
            });
            new Answer().createEditor();
        }
    });
});
