require(
    [
        "jquery",
        "underscore",
        "cq/widget/loading"
    ],
    function (
        $,
        _,
        loading) {

        // Random sample data created via PopulateQuestionsTest
        var BLANK_EXP_DATA = '[{"date":1390741200000,"value":0,"bucket":-20},{"date":1391346000000,"value":10,"bucket":-19},{"date":1391950800000,"value":10,"bucket":-18},{"date":1392555600000,"value":10,"bucket":-17},{"date":1393160400000,"value":0,"bucket":-16},{"date":1393765200000,"value":0,"bucket":-15},{"date":1394370000000,"value":0,"bucket":-14},{"date":1394974800000,"value":0,"bucket":-13},{"date":1395579600000,"value":20,"bucket":-12},{"date":1396184400000,"value":10,"bucket":-11},{"date":1396792800000,"value":20,"bucket":-10},{"date":1397397600000,"value":30,"bucket":-9},{"date":1398002400000,"value":20,"bucket":-8},{"date":1398607200000,"value":20,"bucket":-7},{"date":1399212000000,"value":45,"bucket":-6},{"date":1399816800000,"value":70,"bucket":-5},{"date":1400421600000,"value":50,"bucket":-4},{"date":1401026400000,"value":10,"bucket":-3},{"date":1401631200000,"value":40,"bucket":-2},{"date":1402236000000,"value":50,"bucket":-1},{"date":1402840800000,"value":25,"bucket":0}]';

        function getChartData(username) {
            return  $.ajax({
                url: AJS.contextPath() + "/rest/questions/1.0/experts/reputation/timeseries?username=" + username,
                cache: false,
                type: "GET",
                dataType: "json"
            });
        }

        function getMinMaxValues(chart) {
            var yMin = 0; // Always use 0 as baseline
            var yMax = Number.MIN_VALUE;
            var xMin = Number.MAX_VALUE;
            var xMax = Number.MIN_VALUE;

            _.each(chart, function (data) {
                yMax = Math.max(yMax, data[1]);
                xMin = Math.min(xMin, data[0]);
                xMax = Math.max(xMax, data[0]);
            });

            return [
                [xMin, yMin],
                [xMax, yMax]
            ];
        }

        function makeChartFn(data) {
            var reputation = 0;
            var dataPointToArray = function(datapoint) {
                reputation += datapoint.value;
                return [datapoint.date, reputation]
            };
            var chartValues = _.map(data, dataPointToArray);

            function reputationPlot() {
                return c3.layerable().data(chartValues)
                    .addLayer("grid", c3.axis()
                        .axisConstructor(function() {
                            var tickSize = -this.width();
                            return d3.svg.axis().tickSize(tickSize).ticks(4).tickFormat('');
                        }).orient("left"))
                    .addLayer("green area", c3.areaPlot().areaConstructor(function () {
                        return d3.svg.area().interpolate("monotone");
                    }))
                    .addLayer("green line", c3.linePlot().lineConstructor(function () {
                        return d3.svg.line().interpolate("monotone");
                    }))
            }

            return c3.component("cqChart")
                .extend(c3.borderLayout())
                .south(c3.axis()
                    .axisConstructor(function () {
                        return d3.svg.axis()
                            .tickFormat(function(d) {
                                return d3.time.format("%d/%m")(new Date(d));
                            })
                    })
                    .height(30))
                .west(c3.axis()
                    .axisConstructor(function () {
                        var format = d3.format("0d");
                        return d3.svg.axis()
                            .tickSize(0)
                            .tickPadding(7)
                            .ticks(4)
                            .tickFormat(function(d) {
                                return format(d);
                            });
                    })
                    .orient("left").width(50))
                .north(c3.withDimensions().height(10)) // just some padding
                .east(c3.withDimensions().width(20)) // just some padding
                .center(reputationPlot())
                .data(getMinMaxValues(chartValues));
        }

        $(function () {

            var $reputationPanel = $(".cq-reputation");
            var dfd = getChartData($reputationPanel.data("username"));

            dfd.done(function (data) {

                var blankExperience = false;
                if (data.length == 0) {
                    // blank exp, get dummy data
                    data = JSON.parse(BLANK_EXP_DATA);
                    blankExperience = true;
                }

                var chartFn = makeChartFn(data);
                chartFn(d3.select(".cq-reputation-chart svg"));

                if (blankExperience) {
                    var $chartOuter = $(".cq-reputation-chart");
                    $chartOuter.addClass("cq-chart-blank-experience");
                    $chartOuter.append(CQ.Templates.feature.profile.blankMessage());
                }
            });


            // fade in
            var $chartContainer = $(".cq-reputation-data");
            $chartContainer.css({opacity: 0});
            dfd.done(function () {
                $chartContainer.animate({opacity: 1}, 500);
            });

            // ajax indicator for tests
            $chartContainer.attr("data-ajax-request", true);
            dfd.always(function () {
                $chartContainer.attr("data-ajax-request", false);
            });

            // spinner
            var sectionSpinner = new loading.SectionSpinner($reputationPanel);
            sectionSpinner.showUntilResolved(dfd);
        });
    });