define("cq/feature/profile",
        [
            "jquery",
            "underscore",
            "cq/widget/infinite-list",
            "cq/api/question-service",
            "cq/util/analytics",
            "cq/util/injecteddata",
            "exports"
        ],
        function (
                $,
                _,
                infiniteList,
                questionService,
                analytics,
                injectedData,
                exports) {

            function initAnalytics() {
                var currentFilter = $(".filter-control li[aria-pressed='true'] a").attr("data-filter");
                analytics.trackEvent("profilelist", "view-" + currentFilter);

                $(document).on("click", ".cq-topic-label", function () {
                    analytics.trackEvent("profilelist", "topiclabelclick");
                });
            }

            function buildQuery(ajaxPageSize, startIndex) {

                var $questionList = $(".cq-questionlist");

                return {
                    startIndex: startIndex,
                    pageSize: ajaxPageSize,
                    filter: getActiveFilter(),
                    username: $questionList.data("username")
                };
            }

            function getQuestions(ajaxPageSize, startIndex) {
                return questionService.getQuestions(buildQuery(ajaxPageSize, startIndex));
            }

            function renderQuestion(question) {
                return CQ.Templates.feature.questionlist.question({question: question.toJSON()}, null, injectedData.get());
            }

            function getAnswers(ajaxPageSize, startIndex) {
                return questionService.getAnswers(buildQuery(ajaxPageSize, startIndex));
            }

            function renderAnswer(answer) {
                return CQ.Templates.feature.profile.answer({answer: answer.toJSON(), question: answer.get('question')});
            }

            function getActiveFilter() {
                return $(".cq-filters li[aria-pressed='true'] a").attr("data-filter");
            }

            function initScrollLoader() {
                var activeFilter = getActiveFilter();
                var $questionList = $(".cq-questionlist");

                var options = {
                    $el: $questionList
                };

                if (activeFilter == "my") {
                    options = _.extend(options, {
                        render: renderQuestion,
                        load: getQuestions
                    });
                    infiniteList.init(options);
                } else if (activeFilter == "answered_by") {
                    options = _.extend(options, {
                        render: renderAnswer,
                        load: getAnswers
                    });
                    infiniteList.init(options);
                }
            }

            exports.onReady = function() {
                $(function () {
                    initAnalytics();
                    initScrollLoader();
                });
            };
        });