define("cq/feature/experts",
    [
        "jquery",
        "underscore",
        "cq/widget/loading",
        "cq/api/expert-service",
        "exports"
    ],
    function (
        $,
        _,
        loadingUtil,
        expertService,
        exports) {

        exports.onReady = function () {
            var $expertsMonth = $("#cq-experts-month");
            var $expertsAll = $("#cq-experts-all");
            $(function () {
                var NUMBER_OF_EXPERTS = 10;
                var dfdMonth = expertService.getExpertsForPeriod(1, NUMBER_OF_EXPERTS);
                var expertsMonthSectionSpinner = new loadingUtil.SectionSpinner($expertsMonth, "cq-section-loading-indicator");
                expertsMonthSectionSpinner.showUntilResolved(dfdMonth);
                dfdMonth.done(renderExpertsMonth);

                var dfdAll = expertService.getExpertsForPeriod("alltime", NUMBER_OF_EXPERTS);
                var expertsAllSectionSpinner = new loadingUtil.SectionSpinner($expertsAll, "cq-section-loading-indicator");
                expertsAllSectionSpinner.showUntilResolved(dfdAll);
                dfdAll.done(renderExpertsAll);
            });

            function renderExpertsMonth(experts) {
                if (!!experts) {
                    $expertsMonth.append($(CQ.Templates.feature.experts.expertsList({experts: experts})).hide().fadeIn(400));
                }
            }

            function renderExpertsAll(experts) {
                if (!!experts && !!experts.topExpert) {
                    $expertsAll.append($(CQ.Templates.feature.experts.expertsList({experts: experts})).hide().fadeIn(400));
                } else {
                    $(".cq-experts").empty().append($(CQ.Templates.feature.experts.blank({text: AJS.I18n.getText('cq.blank.question.description.experts')})));
                }
            }
        };
    }
);
