
define("cq/feature/askquestion/topic",
    [
        "jquery",
        "underscore",
        "cq/util/util",
        "cq/util/analytics",
        "cq/widget/topics-selector",
        "exports",
        "cq/widget/loading"
    ],
    function (
        $,
        _,
        util,
        analytics,
        topicSelector,
        exports,
        loadingUtil) {

        function selectTopic(topicName) {
            var $topicSelector = $("#cq-question-topics");

            var selectedTopics = $topicSelector.select2("val");
            selectedTopics.push(topicName);
            $topicSelector.select2("val", selectedTopics);
        }

        function initPopularTopics(topicInfos) {
            topicInfos = _.first(topicInfos, 5);
            var topics = _.pluck(topicInfos, "topic");

            $(".cq-popular-topics-content")
                .html(CQ.Templates.widget.inlineTopics({topics: topics}))
                .on("click", "a", function (e) {
                    e.preventDefault();

                    // click on popular topic label adds it to the list of selected topics
                    var topic = $(this).data("topic");
                    selectTopic(topic);
                })
                .on("click", "a", function () {
                    analytics.trackEvent("askquestion", "addpopulartopic");
                });

            if (topics.length > 0) {
                $(".cq-popular-topics").show();
            }
        }

        function initFeaturedTopics(topics) {
            if (topics.length === 0) {
                return;
            }

            $(".cq-featured-topics")
                .html(CQ.Templates.feature.askquestion.featuredTopicsContent({topics: topics}))
                .on("click", ".cq-topic", function (e) {
                    e.preventDefault();

                    var topic = $(this).data("topic");
                    selectTopic(topic);
                })
                .on("click", ".cq-topic", function () {
                    analytics.trackEvent("askquestion", "addfeaturedtopic");
                });
        }

        function makeTopicSelect() {
            topicSelector.initSelector($("#cq-question-topics"));
            var getTopics = $.getJSON(AJS.contextPath() + "/rest/questions/1.0/topic/suggest?loadAvatar=false&query=");
            getTopics.done(initPopularTopics);

            var getFeaturedTopics = $.getJSON(AJS.contextPath() + "/rest/questions/1.0/topic/featured");
            getFeaturedTopics.done(initFeaturedTopics);

            var topicSelectorSpinner = new loadingUtil.SectionSpinner($(".cq-topics-wrapper").parent(), "cq-topics-loading-indicator");
            topicSelectorSpinner.show();

            $.when(getTopics, getFeaturedTopics).then(fadeInTopics);

            // avoid submit the question when pressing enter
            $(".cq-question-topics .select2-input").on("keydown", function(e) {
                if (e.which === 13) {
                    e.preventDefault();
                }
            });

            function fadeInTopics() {
                topicSelectorSpinner.hide();
                $(".cq-topics-wrapper").fadeIn(400);
            }
        }

        exports.onReady = function() {
            makeTopicSelect();
        };
    });