[#ftl]
[#assign soapAvailable=docsxml.soap.wsdls.wsdl.endpointInterface?size > 0/]
[#assign restAvailable=docsxml.rest.resources.resource?size > 0/]
[#function scrubPathToFilename path]
  [#return "path_" + path?string?replace("/", "_")?replace(":","-")?replace("{", "-")?replace("}", "-") + ".html"/]
[/#function]
[#function tocNeeded(nodelist)]
  [#return nodelist?size > 2/]
[/#function]
[#function attributeExists(node)]
  [#if node?size??]
    [#--if there is a 'size' property, then it's not an attribute--]
    [#return node?size > 0/]
  [#else]
    [#return node?node_type = "attribute"/]
  [/#if]
[/#function]
[#function facetApplicable element facetName]
  [#list element.facets.facet as facet]
    [#if facet.name = facetName]
      [#return true/]
    [/#if]
  [/#list]
  [#return false/]
[/#function]
[#function isDeprecated element]
  [#return (getTagValues(element, "deprecated")?size > 0)/]
[/#function]
[#function getTagValues element tagName]
  [#assign tagvalues = [] /]
  [#list element.tag as tag]
    [#if tag.@name=tagName]
      [#assign tagvalues = tagvalues + [ tag ] /]
    [/#if]
  [/#list]
  [#if element?node_name = "resource"]
    [#assign operationtags = [] /]
    [#list element.operation as operation]
      [#list operation.tag as tag]
        [#if tag.@name=tagName]
          [#assign operationtags = operationtags + [ tag ] /]
        [/#if]
      [/#list]
    [/#list]
    [#if operationtags?size = element.operation?size]
      [#assign tagvalues = tagvalues + [ operationtags[0] ]/]
    [/#if]
  [/#if]
  [#return tagvalues/]
[/#function]

[#--set up the subnavigation menus--]
[#assign nav_sections = { "Data Model" : "model.html"} /]
[#if soapAvailable]
  [#assign nav_sections = nav_sections + { "SOAP" : "soap.html" }/]
[/#if]
[#if restAvailable]
  [#assign nav_sections = nav_sections + { "REST" : "rest.html" }/]
[/#if]
[#if ((downloadsxml??) && (downloadsxml.download?size > 0))]
  [#assign nav_sections = nav_sections + { "Files and Libraries" : "downloads.html"} /]
[/#if]

[#assign nav_resource_facets = {}/]
[#if groupRestResources??]
  [#list docsxml.rest.facets.facet?sort_by("value") as facet]
    [#if facet.name = groupRestResources]
      [#assign nav_resource_facets = nav_resource_facets + { facet.value : "resource_" + facet.value + ".html"}/]
    [/#if]
  [/#list]
[/#if]

[#assign nav_paths = {}/]
[#list docsxml.rest.resources.resource?sort_by("@name") as resource]
  [#assign nav_paths = nav_paths + {resource.@name?string : scrubPathToFilename(resource.@name)}/]
[/#list]

[#assign nav_wsdls = {}/]
[#assign nav_eis_by_ns = {}/]
[#list docsxml.soap.wsdls.wsdl as wsdl]
  [#assign nav_wsdls = nav_wsdls + {wsdl.@namespaceId?string : "soap_" + wsdl.@namespaceId?string + ".html"}/]
  [#assign nav_eis_by_ns = nav_eis_by_ns + {wsdl.@namespaceId?string : {}}/]
  [#list wsdl.endpointInterface?sort_by("@name") as endpointInterface]
    [#assign tmp = nav_eis_by_ns[wsdl.@namespaceId?string] + {endpointInterface.@name?string : "soap_" + wsdl.@namespaceId?string + "_" + endpointInterface.@name?string + ".html"}/]
    [#assign nav_eis_by_ns = nav_eis_by_ns + {wsdl.@namespaceId?string : tmp}/]
  [/#list]
[/#list]

[#assign nav_models = {}/]
[#assign nav_typedefs_by_ns = {}/]
[#assign nav_elements_by_ns = {}/]
[#list docsxml.data.schema as schema]
  [#assign nav_models = nav_models + {schema.@namespaceId?string : schema.@namespaceId?string + ".html"}/]
  [#assign nav_elements_by_ns = nav_elements_by_ns + {schema.@namespaceId?string : {}}/]
  [#list schema.elements.element?sort_by("@name") as element]
    [#assign tmp = nav_elements_by_ns[schema.@namespaceId?string] + { element.@name?string + " element" : "el_" + schema.@namespaceId?string + "_" + element.@name?string + ".html"}/]
    [#assign nav_elements_by_ns = nav_elements_by_ns + {schema.@namespaceId?string : tmp}/]
  [/#list]
  [#assign nav_typedefs_by_ns = nav_typedefs_by_ns + {schema.@namespaceId?string : {}}/]
  [#list schema.types.type?sort_by("@name") as type]
    [#assign tmp = nav_typedefs_by_ns[schema.@namespaceId?string] + {type.@name?string : schema.@namespaceId?string + "_" + type.@name?string + ".html"}/]
    [#assign nav_typedefs_by_ns = nav_typedefs_by_ns + {schema.@namespaceId?string : tmp}/]
  [/#list]
[/#list]

[#macro boilerplate title=docsxml.@title!"Web API" subnav=[{"title" : "Home", "href" : indexPageName}] codeblocks=true]
<!doctype html>
<!-- paulirish.com/2008/conditional-stylesheets-vs-css-hacks-answer-neither/ -->
<!--[if lt IE 7 ]> <html class="no-js ie6" lang="en"> <![endif]-->
<!--[if IE 7 ]>    <html class="no-js ie7" lang="en"> <![endif]-->
<!--[if IE 8 ]>    <html class="no-js ie8" lang="en"> <![endif]-->
<!--[if (gte IE 9)|!(IE)]><!--> <html class="no-js" lang="en"> <!--<![endif]-->
<head>
  <meta charset="utf-8">

  <!-- Always force latest IE rendering engine (even in intranet) & Chrome Frame
       Remove this if you use the .htaccess -->
  <meta http-equiv="X-UA-Compatible" content="IE=edge,chrome=1">

  <title>${title}</title>

  <!-- Mobile viewport optimized: j.mp/bplateviewport -->
  <meta name="viewport" content="width=device-width, initial-scale=1.0">

  <!-- CSS: implied media="all" -->
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/prettify/r298/prettify.min.css" media="all">

  [#list additionalCssFiles as additionalCssFile]
  <link rel="stylesheet" href="${additionalCssFile}">
  [/#list]
  <link rel="stylesheet" href="https://aui-cdn.atlassian.com/aui-adg/5.8.12/css/aui.css" media="all">
  <link rel="stylesheet" href="https://aui-cdn.atlassian.com/aui-adg/5.8.12/css/aui-experimental.css" media="all">
  <link rel="stylesheet" href="css/custom.css" media="all">

  <!-- All JavaScript at the bottom, except for Modernizr which enables HTML5 elements & feature detects -->
  <script src="https://cdnjs.cloudflare.com/ajax/libs/modernizr/2.8.3/modernizr.min.js"></script>
</head>

<body class="aui-page-fixed" cz-shortcut-listen="true">
  <div id="page">
    <header id="header" role="banner">
      <nav class="aui-header aui-dropdown2-trigger-group" data-aui-responsive="true" role="navigation">
        <div class="aui-header-inner">
          <div class="aui-header-primary">
            <h1 id="logo" class="aui-header-logo aui-header-logo-confluence-questions"><a href="${indexPageName}"><span class="aui-header-logo-device">${title}</span></a></h1>
            <ul class="aui-nav">
              [#if soapAvailable]
              <li id="nav-soap"><a href="soap.html">SOAP</a></li>
              [/#if]
              [#if restAvailable]
              <!--li id="nav-rest"><a href="rest.html">REST</a></li-->
              [/#if]
              <li id="nav-data"><a href="model.html">Data Model</a></li>
              [#if ((downloadsxml??) && (downloadsxml.download?size > 0))]
              <li id="nav-downloads"><a href="downloads.html">Files and Libraries</a></li>
              [/#if]
            </ul>
          </div>
        </div>
      </nav>
    </header>

    <!--div>
      <ul class="xbreadcrumbs" id="breadcrumbs">
      [#list subnav as crumb]
        <li[#if !crumb_has_next] class="current"[/#if]>
          <a href="${crumb.href}"[#if crumb_index = 0] class="home"[/#if]>${crumb.title}</a>[#if crumb_has_next] &gt;[/#if]
          [#if crumb.subnav??]
          <ul>
            [#list crumb.subnav?keys as label]
            <li><a href="${crumb.subnav[label]}">${label}</a></li>
            [/#list]
          </ul>
          [/#if]
        </li>
      [/#list]
      </ul>
    </div-->
    <section id="content" role="main">
        <header class="aui-page-header">
            <div class="aui-page-header-inner">
                <div class="aui-page-header-main intro-header">
                    <h1 id="indexheader">Questions for Confluence - REST APIs<span id="header-version" class="aui-lozenge aui-lozenge-success">PUBLIC SINCE 2.3</span></h1>
                    <p class="subtitle">by Atlassian for Confluence Server 5.3+ and Confluence Cloud
                    </p>
                </div>
            </div>
        </header>
      <div class="aui-page-panel">
        <div class="aui-page-panel-inner">
          <section class="aui-page-panel-content" id="main-content">
            [#nested/]
          </section>
        </div>
      </div>
      <div class="clear" />
    </div>
    <footer id="footer" role="contentinfo">
        <section class="footer-body">
            <ul>
                [#if attributeExists(docsxml.@copyright)]
                <li>Copyright &copy; <script type="text/javascript" language="javascript">d = new Date;document.write(d.getFullYear());</script> <span xmlns:cc="http://creativecommons.org/ns#" property="cc:attributionName">${docsxml.@copyright}</span></li>
                [/#if]
                <li><a href="http://atlassian.com/company/trademark" target="_blank">Trademark</a></li>
                <li><a href="http://atlassian.com/company/privacy" target="_blank">Privacy</a></li>
                <li class="version">2.0.16</li>
                <li>Generated by <a href="http://enunciate.codehaus.org">Enunciate</a></li>
            </ul>
        </section>
    </footer>
  </div> <!--! end of #container -->

  <!-- JavaScript at the bottom for fast page loading -->

  <!-- Grab Google CDN's jQuery, with a protocol relative URL; fall back to local if necessary -->
  <script src="https://ajax.googleapis.com/ajax/libs/jquery/1.8.3/jquery.min.js"></script>
  <script src="lib/jquery.scrollUp.min.js"></script>
  <script src="https://aui-cdn.atlassian.com/aui-adg/5.8.12/js/aui.js"></script>

  <!--AMD Loader, required for experimental components-->
  <script src="https://cdn.rawgit.com/jrburke/almond/0.3.0/almond.js"></script>

  <script src="https://aui-cdn.atlassian.com/aui-adg/5.8.12/js/aui-experimental.js"></script>

  [#if codeblocks]

  <!-- prettify code blocks. see http://code.google.com/p/google-code-prettify/ -->
  <script src="https://cdnjs.cloudflare.com/ajax/libs/prettify/r298/prettify.min.js"></script>

  <script>
      $(function() {
          $.scrollUp({
              animation: 'fade',
              activeOverlay: false,
              scrollImg: {
                active: true,
                type: 'background',
                src: 'images/top.png'
            }
        });
    });
  </script>

  [/#if]
  <!--[if lt IE 7 ]>
    <script src="js/libs/dd_belatedpng.js"></script>
    <script>DD_belatedPNG.fix("img, .png_bg"); // Fix any <img> or .png_bg bg-images. Also, please read goo.gl/mZiyb </script>
  <![endif]-->

[#--
  todo: uncomment to support google analytics measurements...
  <!-- mathiasbynens.be/notes/async-analytics-snippet Change UA-XXXXX-X to be your site's ID -->
  <script>
    var _gaq=[["_setAccount","UA-XXXXX-X"],["_trackPageview"]];
    (function(d,t){var g=d.createElement(t),s=d.getElementsByTagName(t)[0];g.async=1;
    g.src=("https:"==location.protocol?"//ssl":"//www")+".google-analytics.com/ga.js";
    s.parentNode.insertBefore(g,s)}(document,"script"));
  </script>
--]
</body>
</html>
[/#macro]
[@file name=indexPageName charset="utf-8"]
  [@boilerplate]
    [#if docsxml.documentation?size > 0]
      <h1>Introduction</h1>

      <p>${docsxml.documentation}</p>

    [/#if]
    [#if restAvailable]

      <h1>REST Resources</h1>
        <p>
            This is the reference document for the Questions for Confluence <a href="http://en.wikipedia.org/wiki/Representational_State_Transfer">Representational State Transfer (REST)</a> API. The REST APIs are for developers who want to:
        </p>
        <ul>
            <li>Integrate Questions for Confluence with other applications;</li>
            <li>Create scripts that interact with Questions for Confluence; or</li>
            <li>Develop Confluence plugins that enhance the Questions for Confluence UI, using REST to interact with the backend.</li>
        </ul>
        You can read more about developing Confluence plugins in the
        <a href="https://developer.atlassian.com/display/CONFDEV/Confluence+Developer+Documentation">Confluence Developer Documentation</a>.

        <h2 id="gettingstarted">Getting started</h2>
        <p>
            Because the REST APIs are based on open standards, you can use any web development language or command line tool
            capable of generating an HTTP request to access the API. See the
            <a href="https://developer.atlassian.com/display/CONFDEV/Confluence+REST+API+Examples">Confluence REST API Examples</a> for a basic
            usage.
        </p>
        <p>
            If you're already working with the
            <a href="https://developer.atlassian.com/display/DOCS/Atlassian+Plugin+SDK+Documentation">Atlassian SDK</a>,
            the <a href="https://developer.atlassian.com/display/RAB/Overview+of+the+Atlassian+REST+API+Browser">REST API
            Browser</a> is a great tool for exploring and experimenting with the Stash REST API.
        </p>
        <h2>
            <a name="StructureoftheRESTURIs"></a>Structure of the REST URIs</h2>
        <p>
            This REST API provide access to resources (data entities) via URI paths. To use a REST API, your application will
            make an HTTP request and parse the response. The Stash REST API uses JSON as its communication format, and the standard
            HTTP methods like GET, PUT, POST and DELETE. URIs for the REST API resources have the following structure:
        </p>
        <pre>http://host:port/context/rest/questions/api-version/path/to/resource</pre>
        <p>
            For example, the following URI would retrieve the first 10 <strong>questions</strong> on <a href="https://extranet.atlassian.com">https://extranet.atlassian.com</a>.
        </p>
        <pre>https://extranet.atlassian.com/rest/questions/1.0/question?limit=10</pre>
        <p>
            See the API descriptions below for a full list of available resources.
        </p>
        <ul class="rest-resource-list">
            [#if groupRestResources?? && facetApplicable(docsxml.rest, groupRestResources)]
                [#list docsxml.rest.facets.facet?sort_by("value") as facet]
                    [#if facet.name = groupRestResources]
                        [@processResourceFacet facet=facet/]
                        <li><a href="resource_${facet.value}.html">${facet.value}</a></li>
                    [/#if]
                [/#list]
            [#else]
                [#list docsxml.rest.resources.resource?sort_by("@name") as resource]
                    [@processResource resource=resource/]
                    <li[#if isDeprecated(resource)] class="deprecated"[/#if]><a href="${scrubPathToFilename(resource.@name)}">${resource.@name}</a></li>
                [/#list]
            [/#if]
        </ul>
        [#if attributeExists(docsxml.rest.@wadl)]
        <p>
            There is also a <a href="${docsxml.rest.@wadl}">WADL document</a> describing the REST API.
        </p>
        [/#if]
    <h2 id="authentication">Authentication</h2>
    <p>
        Any authentication that works against Confluence will work.
    </p>
    <h2 id="errors-and-validation">Errors &amp; Validation</h2>
    <p>
        If a request fails due to client error, the resource will return an HTTP response code in the 40x range. These can
        be broadly categorised into:
    </p>
    <table class="aui">
        <thead>
            <tr>
                <th>HTTP Code</th>
                <th>Description</th>
            </tr>
        </thead>
        <tbody>
            <tr>
                <td>400 (Bad Request)</td>
                <td>
                    One or more of the required parameters or attributes:
                    <ul>
                        <li>were missing from the request;</li>
                        <li>incorrectly formatted; or</li>
                        <li>inappropriate in the given context.</li>
                    </ul>
                </td>
            </tr>
            <tr>
                <td>401 (Unauthorized)</td>
                <td>
                    Either:
                    <ul>
                        <li>Authentication is required but was not attempted.</li>
                        <li>Authentication was attempted but failed.</li>
                        <li>Authentication was successful but the authenticated user does not have the requisite permission
                            for the resource.</li>
                    </ul>
                    See the individual resource documentation for details of required permissions.
                </td>
            </tr>
            <tr>
                <td>403 (Forbidden)</td>
                <td>
                    Actions are usually "forbidden" if they involve breaching the licensed user limit of the server, or
                    degrading the authenticated user's permission level. See the individual resource documentation for more
                    details.
                </td>
            </tr>
            <tr>
                <td>404 (Not Found)</td>
                <td>
                    The entity you are attempting to access, or the project or repository containing it, does not exist.
                </td>
            </tr>
        </tbody>
    </table>
      [#if ((downloadsxml??) && (downloadsxml.download?size > 0))]
      <p>
        The REST resources expose a data model that is supported by a set of client-side libraries that are made available on the
        <a href="downloads.html">files and libraries</a> page.
      </p>
      [/#if]

      [#if swaggerDir??]
      <h2>Swagger</h2>
      <p>
        You may also enjoy the <a href="${swaggerDir}/index.html">Swagger UI</a> provided for this API.
      </p>
      [/#if]
    [/#if]
    [#if soapAvailable]

      <h1>SOAP Endpoints</h1>
      <p>
        This API is exposed through a set of <a href="http://www.ws-i.org/Profiles/BasicProfile-1.0.html">WSI Basic Profile</a>
        -compliant SOAP v1.1 endpoints. The API supports <a href="http://www.w3.org/TR/2005/REC-xop10-20050125/">XML-binary Optimized Pacakging (XOP)</a>
        and <a href="http://www.w3.org/TR/2004/WD-soap12-mtom-20040608/">SOAP Message Transmission Optimization Mechanism (MTOM)</a>
        for transmission of binary data. The SOAP API is described by the following endpoints:
      </p>
      [#list docsxml.soap.wsdls.wsdl as wsdl]
        [@processWsdl wsdl=wsdl/]
      <h2>Namespace "${wsdl.@namespaceId}"</h2>
      <table class="aui">
        <tr>
          <td align="right">Namespace URI:</td>
          <td>[#if wsdl.@namespace?length > 0]${wsdl.@namespace}[#else](default namespace)[/#if]</td>
        </tr>
        [#if attributeExists(wsdl.@file)]
        <tr>
          <td align="right">WSDL:</td>
          <td><a href="${wsdl.@file}">${wsdl.@file}</a></td>
        </tr>
        [/#if]
      </table>
      <h3>Endpoints</h3>
      <ul>
      [#list wsdl.endpointInterface?sort_by("@name") as endpointInterface]
        [@processEndpointInterface endpointInterface=endpointInterface/]
        <li[#if isDeprecated(endpointInterface)] class="deprecated"[/#if]><a href="soap_${wsdl.@namespaceId}_${endpointInterface.@name}.html">${endpointInterface.@name}</a></li>
      [/#list]
      </ul>
      [/#list]
      [#if ((downloadsxml??) && (downloadsxml.download?size > 0))]
      <p>
        The SOAP API is also accessible by a set of client-side libraries that can be downloaded from the <a href="downloads.html">files and libraries page</a>.
      </p>
      [/#if]
    [/#if]
  [/@boilerplate]
[/@file]
[@file name="model.html" charset="utf-8"]
  [@boilerplate title="Data Model" subnav=[{"title" : "Home", "href" : indexPageName}, {"title" : "Data Model" , "href" : "model.html", "subnav" : nav_sections}]]
  <h1>Data Model</h1>

  <p>
      All endpoints act on a common set of data. The data can be represented with different media (i.e. "MIME") types, depending on the endpoint
      that consumes and/or produces the data. [#if includeExampleJson!true]The data is described in <a href="http://json.org">JSON</a> format.[/#if]
  </p>

  <p>
      Generally speaking, <i>types</i> define the structure of the data and <i>elements</i> are <i>instances</i> of a type. For example,
      <i>elements</i> are usually produced by (or consumed by) a REST endpoint, and the structure of each element is described by
      its <i>type</i>.
  </p>

      [#list docsxml.data.schema as schema]
          [@processSchema schema=schema/]

      <div class="aui-group">
          <div class="aui-item">
              [#if schema.elements.element?size > 0]
                  <h3>Data Elements</h3>

                  <ul class="rest-resource-list">
                      [#list schema.elements.element?sort_by("@name") as element]
                          <li[#if isDeprecated(element)] class="deprecated"[/#if]><a href="el_${schema.@namespaceId}_${element.@name}.html">${element.@name}</a></li>
                      [/#list]
                  </ul>
              [/#if]
          </div>
          <div class="aui-item">
              [#if schema.types.type?size > 0]
                  <h3>Data Types</h3>
                  <ul class="rest-resource-list">
                      [#list schema.types.type?sort_by("@name") as type]
                          <li[#if isDeprecated(type)] class="deprecated"[/#if]><a href="${schema.@namespaceId}_${type.@name}.html">${type.@name}</a></li>
                      [/#list]
                  </ul>
              [/#if]
          </div>
      </div>
      [/#list]
      [#if docsxml.data.jsonSchema.type?size > 0]
      <h1 class="rest-resource-list">JSON Data Types</h1>
      <ul>
          [#list docsxml.data.jsonSchema.type as type]
              [@processJsonType type=type/]
              <li[#if isDeprecated(type)] class="deprecated"[/#if]><a href="json_${type?parent.@schemaId}_${type.@name}.html">${type.@name}</a></li>
          [/#list]
      </ul>
      [/#if]
  [/@boilerplate]
[/@file]
[#if ((downloadsxml??) && (downloadsxml.download?size > 0))]
  [@file name="downloads.html" charset="utf-8"]
    [@boilerplate title="Files and Libraries" subnav=[{"title" : "Home", "href" : indexPageName}, { "title" : "Files and Libraries" , "href" : "downloads.html" , "subnav" : nav_sections}] codeblocks=true]
  <h1>Files and Libraries</h1>

  <p>The following files and libraries are available:</p>

  <ul>
      [#list downloadsxml.download as download]
    <li><a href="#${download.@name}">${download.@name}</a></li>
      [/#list]
  </ul>
      [#list downloadsxml.download as download]
  <a name="${download.@name}"></a>
  <h2>${download.@name}</h2>
        [#list download.created as created]
  <p class="note">Created ${created}</p>
        [/#list]
        [#list download.description as description]
  <p>${description}</p>
        [/#list]
  <h3>Files</h3>
  <table class="aui">
    <tr>
      <th>name</th>
      <th>size</th>
        [#if download.files.file?size > 1]
      <th>description</th>
        [/#if]
    </tr>
        [#list download.files.file as file]
    <tr>
      <td><a href="${file.@name}">${file.@name}</a></td>
      <td>${file.@size}</td>
          [#if file_index > 0 || file_has_next]
      <td>${file}</td>
          [/#if]
    </tr>
        [/#list]
  </table>
      [/#list]
    [/@boilerplate]
  [/@file]
[/#if]
[#if restAvailable]
  [@file name="rest.html" charset="utf-8"]
    [@boilerplate title="REST" subnav=[{"title" : "Home", "href" : indexPageName}, {"title" : "REST" , "href" : "rest.html", "subnav" : nav_sections}]]
  <h1>REST Resources</h1>
  <p>
    This API supports a <a href="http://en.wikipedia.org/wiki/Representational_State_Transfer">Representational State Transfer (REST)</a>
    model for accessing a set of resources through a fixed set of operations. The following resources are accessible through the RESTful model:
  </p>
  <ul class="rest-resource-list">
    [#if groupRestResources?? && facetApplicable(docsxml.rest, groupRestResources)]
      [#list docsxml.rest.facets.facet?sort_by("value") as facet]
        [#if facet.name = groupRestResources]
      <li><a href="resource_${facet.value}.html">${facet.value}</a></li>
        [/#if]
      [/#list]
    [#else]
      [#list docsxml.rest.resources.resource?sort_by("@name") as resource]
      <li[#if isDeprecated(resource)] class="deprecated"[/#if]><a href="${scrubPathToFilename(resource.@name)}">${resource.@name}</a></li>
      [/#list]
    [/#if]
  </ul>
      [#if ((downloadsxml??) && (downloadsxml.download?size > 0))]
  <p>
    The REST resources expose a data model that is supported by a set of client-side libraries that are made available on the
    <a href="downloads.html">files and libraries</a> page.
  </p>
      [/#if]
      [#if attributeExists(docsxml.rest.@wadl)]
  <p>
    There is also a <a href="${docsxml.rest.@wadl}">WADL document</a> describing the REST API.
  </p>
      [/#if]
      [#if swaggerDir??]
  <h2>Swagger</h2>
  <p>
    You may also enjoy the <a href="${swaggerDir}/index.html">Swagger UI</a> provided for this API.
  </p>
      [/#if]
    [/@boilerplate]
  [/@file]
[/#if]
[#macro processResourceFacet facet]
  [@file name="resource_" + facet.value + ".html" charset="utf-8"]
    [@boilerplate title=facet.value subnav=[{"title" : "Home", "href" : indexPageName}, {"title" : "REST" , "href" : "rest.html", "subnav" : nav_sections}, {"title" : facet.value , "href" : "resource_" + facet.value + ".html", "subnav" : nav_resource_facets}]]
      <h1>${facet.value}</h1>

      [#list facet.documentation as documentation]
      <p>${documentation}</p>
      [/#list]
      [#assign resources=[] /]
      [#list docsxml.rest.resources.resource?sort_by("@name") as resource]
        [#list resource.facets.facet as rg]
          [#if ((rg.name = facet.name) && (rg.value == facet.value))]
            [#assign resources=resources + resource /]
            [#break/]
          [/#if]
        [/#list]
      [/#list]
      <p>The following resources are applicable:</p>
      <ul class="rest-resource-list">
        [#list resources as resource]
        <li[#if isDeprecated(resource)] class="deprecated"[/#if]>
        [#if resource.label?has_content]
        <a href="#${scrubPathToFilename(resource.label)}">${resource.label}</a>
        [#else]
        <a href="#${scrubPathToFilename(resource.@name)}">${resource.@name}</a>
        [/#if]
        </li>
        [/#list]
      </ul>
      [#list resources as resource]
        [#if resource.label?has_content]
        <a name="${scrubPathToFilename(resource.label)}"></a>
        [#else]
        <a name="${scrubPathToFilename(resource.@name)}"></a>
        [/#if]
        [@processRawResource resource=resource/]
      [/#list]
    [/@boilerplate]
  [/@file]
[/#macro]
[#macro processResource resource]
  [#assign resource_filename=scrubPathToFilename(resource.@name)/]
  [@file name=resource_filename charset="utf-8"]
    [@boilerplate title=facet subnav=[{"title" : "Home", "href" : indexPageName}, { "title" : "REST" , "href" : "rest.html", "subnav" : nav_sections }, {"title" : resource.@name , "href" : resource_filename, "subnav" : nav_paths}]]
      [@processRawResource resource=resource/]
    [/@boilerplate]
  [/@file]
[/#macro]
[#macro processRawResource resource]
  [#if resource.label?has_content]
      <h1>${resource.label}</h1>
  [#else]
      <h1>${resource.@name}</h1>
  [/#if]
  [#if isDeprecated(resource)]
  <p class="alert">This resource has been deprecated.</p>
  [/#if]
  [#if attributeExists(resource.@subcontext) && !disableRestMountpoint!false]
      <p class="note">Mount Point: <a href="${apiRelativePath}${resource.@subcontext}${resource.@name}">${resource.@subcontext}${resource.@name}</a></p>
  [/#if]
  [#assign sinceTags = getTagValues(resource, "since") /]
  [#if sinceTags?size > 0]
      <p class="note">Available Since: ${sinceTags[0]}</p>
  [/#if]
  [#assign versionTags = getTagValues(resource, "version") /]
  [#if versionTags?size > 0]
      <p class="note">Version: ${versionTags[0]}</p>
  [/#if]
  [#if tocNeeded(resource.operation)]
      <p>
        The following operations are supported on this resource:
      </p>
      <ul>
    [#list resource.operation as operation]
        <li[#if isDeprecated(operation)] class="deprecated"[/#if]><a href="#${operation.@name}${scrubPathToFilename(resource.@name)}">${operation.@name}</a></li>
      [#list operation.alias as alias]
        <li[#if isDeprecated(operation)] class="deprecated"[/#if]><a href="#${operation.@name}${scrubPathToFilename(resource.@name)}">${alias}</a></li>
      [/#list]
    [/#list]
      </ul>
  [/#if]
  [#list resource.operation as operation]
      <a name="${operation.@name}${scrubPathToFilename(resource.@name)}"></a>
      <h2>${operation.@name}</h2>
    [#list operation.alias as alias]
      <p class="note">Alias: ${alias}</p>
    [/#list]
    [#assign sinceTags = getTagValues(operation, "since") /]
    [#if sinceTags?size > 0]
      <p class="note">Available Since: ${sinceTags[0]}</p>
    [/#if]
    [#assign versionTags = getTagValues(operation, "version") /]
    [#if versionTags?size > 0]
      <p class="note">Version: ${versionTags[0]}</p>
    [/#if]
    [#if isDeprecated(operation)]
      <p class="alert">This operation has been deprecated. [#list operation.tag as tag][#if tag.@name="deprecated"] ${tag}[/#if][/#list]</p>
    [/#if]
    [#list operation.documentation as documentation]
      <p>${documentation}</p>
    [/#list]
    [#list operation.parameter as parameter]
      [#if parameter_index = 0]
      <h3>Parameters</h3>
      <table class="aui">
        <tr>
          <th>name</th>
          <th>description</th>
          <th>type</th>
          <th>default</th>
        </tr>
      [/#if]
        <tr>
          <td>[#if attributeExists(parameter.@name)]${parameter.@name}[/#if]</td>
          <td>${parameter}</td>
          <td>[#if attributeExists(parameter.@type)]${parameter.@type}[/#if]</td>
          <td>[#if attributeExists(parameter.@defaultValue)]${parameter.@defaultValue}[/#if]</td>
        </tr>
      [#if !parameter_has_next]
      </table>
      [/#if]
    [/#list]
    [#list operation.inValue as inValue]
      <h3>Request Body</h3>
      <table class="aui">
      [#assign custom=true]
      [#list inValue.xmlElement as xmlElement]
        [#if attributeExists(xmlElement.@elementName)]
          [#assign custom=false/]
        <tr>
          <td align="right">element:</td>
          [#if attributeExists(xmlElement.@elementSchemaId)]
          <td><a href="el_${xmlElement.@elementSchemaId}_${xmlElement.@elementName}.html">${xmlElement.@elementName}</a></td>
          [#else]
          <td>${xmlElement.@elementName}</td>
          [/#if]
        </tr>
        [/#if]
      [/#list]
      [#list inValue.jsonElementRef as jsonElement]
        [#if attributeExists(jsonElement.@elementName)]
          [#assign custom=false/]
        <tr>
          <td align="right">element:</td>
          [#if attributeExists(jsonElement.@elementSchemaId)]
          <td><a href="json_${jsonElement.@elementSchemaId}_${jsonElement.@elementName}.html">${jsonElement.@elementName}</a></td>
          [#else]
          <td>${jsonElement.@elementName}</td>
          [/#if]
        </tr>
        [/#if]
      [/#list]
      [#if custom]
        <tr>
          <td align="right">element:</td>
          [#if operation.customParameterName?has_content]
            <td>${operation.customParameterName}</td>
          [#else]
            <td>(custom)</td>
          [/#if]
        </tr>
      [/#if]
        <tr>
          <td align="right">media types:</td>
          <td>[#list operation.contentType as contentType][#if contentType.@consumable = "true"]${contentType.@type}[#if contentType_has_next]<br/>[/#if][/#if][/#list]</td>
        </tr>
      </table>
      [#list inValue.documentation as documentation]
      <p>${documentation}</p>
      [/#list]
      [#if operation.showSampleRequest?has_content]
      <code class="prettyprint">${operation.@name} ...${resource.@subcontext}${resource.@name}
Accept: [#assign first = true/][#list operation.contentType as contentType][#if contentType.@produceable = "true"][#if !first];[/#if][#assign first=false/]${contentType.@type}[/#if][/#list]
[#if custom]
Content-Type: [#assign first = true/][#list operation.contentType as contentType][#if contentType.@consumable = "true"][#if !first];[/#if][#assign first=false/]${contentType.@type}[/#if][/#list]
[#else]
    [#if operation.showSampleRequest == "JSON"]
Content-Type: application/json
    [#elseif operation.showSampleRequest == "XML"]
Content-Type: application/xml
    [#else]
Content-Type: [#assign first = true/][#list operation.contentType as contentType][#if contentType.@consumable = "true"][#if !first];[/#if][#assign first=false/]${contentType.@type}[/#if][/#list]
    [/#if]
[/#if]
--- Body ---
[#if custom]
    [#if operation.customParameterName?has_content]
[${operation.customParameterName}]
    [#else]
(custom)
    [/#if]
[#else]
    [#list inValue.xmlElement as xmlElement]
        [#if attributeExists(xmlElement.@elementName)]
            [#list docsxml.data.schema as schema]
                [#list schema.elements.element?sort_by("@name") as element]
                    [#if xmlElement.@elementName == element.@name]
                        [#if operation.showSampleRequest == "JSON"]
                            [#list element.examplejson as examplejson]
${examplejson?string?xhtml}
                            [/#list]
                        [#else]
                            [#list element.examplexml as examplexml]
${examplexml?string?xhtml}
                            [/#list]
                        [/#if]
                    [/#if]
                [/#list]
            [/#list]
        [/#if]
    [/#list]
[/#if]
</code>
      [/#if]
    [/#list]
    [#list operation.outValue as outValue]
      <h3>Response Body</h3>
      <table class="aui">
      [#assign custom=true]
      [#list outValue.xmlElement as xmlElement]
        [#if attributeExists(xmlElement.@elementName)]
          [#assign custom=false/]
        <tr>
          <td align="right">element:</td>
          [#if attributeExists(xmlElement.@elementSchemaId)]
          <td><a href="el_${xmlElement.@elementSchemaId}_${xmlElement.@elementName}.html">${xmlElement.@elementName}</a></td>
          [#else]
          <td>${xmlElement.@elementName}</td>
          [/#if]
        </tr>
        [/#if]
      [/#list]
      [#list outValue.jsonElementRef as jsonElement]
        [#if attributeExists(jsonElement.@elementName)]
          [#assign custom=false/]
        <tr>
          <td align="right">element:</td>
          [#if attributeExists(jsonElement.@elementSchemaId)]
          <td><a href="json_${jsonElement.@elementSchemaId}_${jsonElement.@elementName}.html">${jsonElement.@elementName}</a></td>
          [#else]
          <td>${jsonElement.@elementName}</td>
          [/#if]
        </tr>
        [/#if]
      [/#list]
      [#if custom]
        <tr>
          <td align="right">element:</td>
          <td>(custom)</td>
        </tr>
      [/#if]
        <tr>
          <td align="right">media types:</td>
          <td>[#list operation.contentType as contentType][#if contentType.@produceable = "true"]${contentType.@type}[#if contentType_has_next]<br/>[/#if][/#if][/#list]</td>
        </tr>
      </table>
      [#list outValue.documentation as documentation]
      <p>${documentation}</p>
      [/#list]
[#if operation.showSampleResponse?has_content]
      <code class="prettyprint">HTTP/1.1 ${operation.showSampleResponse.@code}
[#if operation.showSampleResponse == "JSON"]
Content-Type: application/json
    [#elseif operation.showSampleResponse == "XML"]
Content-Type: application/xml
    [#else]
Content-Type: [#assign first = true/][#list operation.contentType as contentType][#if contentType.@produceable = "true"][#if !first];[/#if][#assign first=false/]${contentType.@type}[/#if][/#list]
    [/#if]
--- Body ---
[#if custom]    
(custom)
[#else]
    [#list outValue.xmlElement as xmlElement]
        [#if attributeExists(xmlElement.@elementName)]
            [#list docsxml.data.schema as schema]
                [#list schema.elements.element?sort_by("@name") as element]
                    [#if xmlElement.@elementName == element.@name]
                        [#if operation.showSampleResponse == "JSON"]
                            [#list element.examplejson as examplejson]
${examplejson?string?xhtml}
                            [/#list]
                        [#else]
                            [#list element.examplexml as examplexml]
${examplexml?string?xhtml}
                            [/#list]
                        [/#if]
                    [/#if]
                [/#list]
            [/#list]
        [/#if]
    [/#list]
[/#if]
</code>
      [/#if]
    [/#list]
    [#list operation.statusCode as statusCode]
      [#if statusCode_index = 0]
      <h3>Status Codes</h3>
      <table class="aui">
        <tr>
          <th width="130">HTTP Status Code</th>
          <th>Description</th>
          [#list operation.additionalHeaderLabels.label as label]
          <th>${label}</th>
          [/#list]
        </tr>
      [/#if]
        <tr>
          <td>${statusCode.@code}</td>
          <td>${statusCode.condition}</td>
          [#list statusCode.additionalHeaders.additionalHeader as header]
            <td>${header}</td>
          [/#list]
        </tr>
      [#if !statusCode_has_next]
      </table>
      [/#if]
    [/#list]
    [#list operation.warning as warning]
      [#if warning_index = 0]
      <h3>Warnings</h3>
      <table class="aui">
        <tr>
          <th>HTTP Status Code</th>
          <th>Description</th>
        </tr>
      [/#if]
        <tr>
          <td>${warning.@code}</td>
          <td>${warning}</td>
        </tr>
      [#if !warning_has_next]
      </table>
      [/#if]
    [/#list]
    [#list operation.responseHeader as responseHeader]
      [#if responseHeader_index = 0]
      <h3>Response Headers</h3>
      <table class="aui">
        <tr>
          <th>name</th>
          <th>description</th>
        </tr>
      [/#if]
        <tr>
          <td>${responseHeader.name}</td>
          <td>${responseHeader.documentation}</td>
        </tr>
      [#if !responseHeader_has_next]
      </table>
      [/#if]
    [/#list]
  [/#list]
[/#macro]
[#macro processEndpointInterface endpointInterface]
  [@file name="soap_" + endpointInterface?parent.@namespaceId + "_" + endpointInterface.@name + ".html" charset="utf-8"]
    [@boilerplate title=endpointInterface.@name subnav=[{"title" : "Home", "href" : indexPageName}, {"title" : "SOAP" , "href" : "soap.html", "subnav" : nav_sections }, {"title" : endpointInterface?parent.@namespaceId , "href" : "soap_" + endpointInterface?parent.@namespaceId + ".html", "subnav" : nav_wsdls }, {"title" : endpointInterface.@name , "href" : "soap_" + endpointInterface.@name + ".html", "subnav" : nav_eis_by_ns[endpointInterface?parent.@namespaceId?string]}]]
      <h1>${endpointInterface.@name}</h1>
      [#if isDeprecated(endpointInterface)]
      <p class="alert">This endpoint has been deprecated.[#list endpointInterface.tag as tag][#if tag.@name="deprecated"] ${tag}[/#if][/#list]</p>
      [/#if]
      <table class="aui">
        [#if attributeExists((endpointInterface?parent).@file)]
        <tr>
          <td align="right">WSDL:</td>
          <td><a href="${(endpointInterface?parent).@file}">${(endpointInterface?parent).@file}</a></td>
        </tr>
        [/#if]
        [#if attributeExists(endpointInterface.@path)]
          <tr>
            <td align="right">Path:</td>
            <td><a href="${apiRelativePath}${endpointInterface.@path}">${endpointInterface.@path}</a></td>
          </tr>
        [/#if]
        [#assign sinceTags = getTagValues(endpointInterface, "since") /]
        [#if sinceTags?size > 0]
          <tr>
            <td align="right">Available Since:</td>
            <td>${sinceTags[0]}</td>
          </tr>
        [/#if]
        [#assign versionTags = getTagValues(endpointInterface, "version") /]
        [#if versionTags?size > 0]
          <tr>
            <td align="right">Version:</td>
            <td>${versionTags[0]}</td>
          </tr>
        [/#if]
      </table>
      [#if endpointInterface.documentation?size > 0]
        [#list endpointInterface.documentation as documentation]
      <p>${documentation}</p>
        [/#list]
      [/#if]
      [#if tocNeeded(endpointInterface.method)]
      <p>
        The following methods are available on this endpoint:
      </p>
      <ul>
        [#list endpointInterface.method as method]
        <li[#if isDeprecated(method)] class="deprecated"[/#if]><a href="#${method.@name}">${method.@name}</a></li>
        [/#list]
      </ul>
      [/#if]
      [#list endpointInterface.method as method]
      <a name="${method.@name}"></a>
      <h2>${method.@name}</h2>
        [#if isDeprecated(method)]
      <p class="alert">This method has been deprecated.[#list method.tag as tag][#if tag.@name="deprecated"] ${tag}[/#if][/#list]</p>
        [/#if]
        [#assign sinceTags = getTagValues(method, "since") /]
        [#if sinceTags?size > 0]
      <p class="note">Available Since: ${sinceTags[0]}</p>
        [/#if]
        [#assign versionTags = getTagValues(method, "version") /]
        [#if versionTags?size > 0]
      <p class="note">Version: ${versionTags[0]}</p>
        [/#if]
        [#list method.documentation as documentation]
      <p>${documentation}</p>
        [/#list]
      <h3>Input Parameters</h3>
        [#assign anyInputParameters=false/]
        [#list method["parameter[@input='true']"] as parameter]
          [#assign anyInputParameters=true/]
          [#if parameter_index = 0]
      <table class="aui">
        <tr>
          <th>name</th>
          <th>type</th>
          <th>description</th>
        </tr>
          [/#if]
        <tr>
          <td>${parameter.@name}</td>
          <td>[#if attributeExists(parameter.@xmlTypeName)][#if attributeExists(parameter.@xmlTypeSchemaId)]<a href="${parameter.@xmlTypeSchemaId}_${parameter.@xmlTypeName}.html">${parameter.@xmlTypeName}</a>[#else]${parameter.@xmlTypeName}[/#if][#else](unknown)[/#if]</td>
          <td>${parameter}</td>
        </tr>
          [#if !parameter_has_next]
      </table>
          [/#if]
        [/#list]
        [#if !anyInputParameters]
      <p>(none)</p>
        [/#if]
        [#list method["parameter[@output='true']"] as parameter]
          [#if parameter_index = 0]
      <h3>Output Parameters</h3>
      <table class="aui">
        <tr>
          <th>name</th>
          <th>type</th>
          <th>description</th>
        </tr>
          [/#if]
        <tr>
          <td>${parameter.@name}</td>
          <td>[#if attributeExists(parameter.@xmlTypeName)][#if attributeExists(parameter.@xmlTypeSchemaId)]<a href="${parameter.@xmlTypeSchemaId}_${parameter.@xmlTypeName}.html">${parameter.@xmlTypeName}</a>[#else]${parameter.@xmlTypeName}[/#if][#else](unknown)[/#if]</td>
          <td>${parameter}</td>
        </tr>
          [#if !parameter_has_next]
      </table>
          [/#if]
        [/#list]
      <h3>Return Value</h3>
        [#assign anyReturnValue=false/]
        [#list method.result as result]
          [#assign anyReturnValue=true/]

          [#if attributeExists(result.@xmlTypeName)]
      <table class="aui">
        <tr>
          <td align="right">Type:</td>
          <td>[#if attributeExists(result.@xmlTypeSchemaId)]<a href="${result.@xmlTypeSchemaId}_${result.@xmlTypeName}.html">${result.@xmlTypeName}</a>[#else]${result.@xmlTypeName}[/#if]</td>
        </tr>
      </table>
          [/#if]

      <p>${result}</p>
        [/#list]
        [#if !anyReturnValue]
      <p>(none)</p>
        [/#if]
        [#list method.fault as fault]
          [#if fault_index = 0]
      <h3>Faults</h3>
      <table class="aui">
        <tr>
          <th>name</th>
          <!--todo: add the parameter type and whether its a collection-->
          <th>description</th>
        </tr>
          [/#if]
        <tr>
          <td>${fault.@name}</td>
          <td>${fault}</td>
        </tr>
          [#if !fault_has_next]
      </table>
          [/#if]
        [/#list]
      [/#list]
    [/@boilerplate]
  [/@file]
[/#macro]
[#macro processSchema schema]
  [@file name=schema.@namespaceId + ".html" charset="utf-8"]
    [@boilerplate title="Namespace: " + schema.@namespaceId subnav=[{"title" : "Home", "href" : indexPageName}, {"title" : "Data Model" , "href" : "model.html", "subnav" : nav_sections}, {"title" : schema.@namespaceId , "href" : schema.@namespaceId + ".html", "subnav" : nav_models}]]
      [#if schema.elements.element?size > 0]

      <h2>Elements</h2>
      
      <ul>
        [#list schema.elements.element?sort_by("@name") as element]
        [@processElement element=element/]
        <li[#if isDeprecated(element)] class="deprecated"[/#if]><a href="el_${schema.@namespaceId}_${element.@name}.html">${element.@name}</a></li>
        [/#list]
      </ul>
      [/#if]
      [#if schema.types.type?size > 0]

      <h2>Types</h2>
      
      <ul>
        [#list schema.types.type?sort_by("@name") as type]
        [@processType type=type/]
        <li[#if isDeprecated(type)] class="deprecated"[/#if]><a href="${schema.@namespaceId}_${type.@name}.html">${type.@name}</a></li>
        [/#list]
      </ul>
      [/#if]
    [/@boilerplate]
  [/@file]
[/#macro]
[#macro processElement element]
  [#assign schema=element?parent?parent/]
  [@file name="el_" + schema.@namespaceId + "_" + element.@name + ".html" charset="utf-8"]
    [@boilerplate title=element.@name subnav=[{"title" : "Home", "href" : indexPageName}, {"title" : "Data Model" , "href" : "model.html", "subnav" : nav_sections}, {"title" : schema.@namespaceId , "href" : schema.@namespaceId + ".html", "subnav" : nav_models}, {"title" : element.@name + " element" , "href" : "el_" + schema.@namespaceId + "_" + element.@name + ".html", "subnav" : nav_elements_by_ns[schema.@namespaceId?string]}] codeblocks=true]
      <h1>${element.@name} element</h1>
      [#if isDeprecated(element)]
      <p class="alert">This element has been deprecated.[#list element.tag as tag][#if tag.@name="deprecated"] ${tag}[/#if][/#list]</p>
      [/#if]
      <table class="aui">
      [#if attributeExists(element.@typeName) && attributeExists(element.@typeSchemaId)]
        <tr>
          <td align="right">Type:</td>
          <td><a href="${element.@typeSchemaId}_${element.@typeName}.html">${element.@typeName}</a></td>
        </tr>
      [/#if]
        [#assign sinceTags = getTagValues(element, "since") /]
        [#if sinceTags?size > 0]
        <tr>
          <td align="right">Available Since:</td>
          <td>${sinceTags[0]}</td>
        </tr>
        [/#if]
        [#assign versionTags = getTagValues(element, "version") /]
        [#if versionTags?size > 0]
        <tr>
          <td align="right">Available Version:</td>
          <td>${versionTags[0]}</td>
        </tr>
        [/#if]
      </table>
      [#list element.documentation as documentation]
      <p>${documentation}</p>
      [/#list]
      [#list element.examplejson as examplejson]
      <h2>Example JSON</h2>
      <code class="prettyprint lang-js">${examplejson?string?xhtml}</code>
      [/#list]
    [/@boilerplate]
  [/@file]
[/#macro]
[#macro processType type]
  [#assign schema=type?parent?parent/]
  [@file name=schema.@namespaceId + "_" + type.@name + ".html" charset="utf-8"]
    [@boilerplate title=type.@name subnav=[{"title" : "Home", "href" : indexPageName}, {"title" : "Data Model" , "href" : "model.html", "subnav" : nav_sections}, {"title" : schema.@namespaceId , "href" : schema.@namespaceId + ".html", "subnav" : nav_models} , {"title" : type.@name , "href" : schema.@namespaceId + "_" + type.@name + ".html", "subnav" : nav_typedefs_by_ns[schema.@namespaceId?string]}] codeblocks=true]
      <h1>${type.@name}</h1>
      [#if isDeprecated(type)]
      <p class="alert">This type has been deprecated.[#list type.tag as tag][#if tag.@name="deprecated"] ${tag}[/#if][/#list]</p>
      [/#if]
      <table class="aui">
      [#if attributeExists(type.@extendsType)]
        [#list docsxml.data.schema.types.type as candidate]
          [#if attributeExists(candidate.@id) && (candidate.@id?string = type.@extendsType?string)]
        <tr>
          <td align="right">Extends:</td>
          <td><a href="${candidate?parent?parent.@namespaceId}_${candidate.@name}.html">${candidate.@name}</a></td>
        </tr>
            [#break/]
          [/#if]
        [/#list]
      [/#if]
        [#assign sinceTags = getTagValues(type, "since") /]
        [#if sinceTags?size > 0]
        <tr>
          <td align="right">Available Since:</td>
          <td>${sinceTags[0]}</td>
        </tr>
        [/#if]
        [#assign versionTags = getTagValues(type, "version") /]
        [#if versionTags?size > 0]
        <tr>
          <td align="right">Version:</td>
          <td>${versionTags[0]}</td>
        </tr>
        [/#if]
      </table>
      [#list type.documentation as documentation]
      <p>${documentation}</p>
      [/#list]

      [#if type.values.item?size > 0]
        [#list type.values.item as value]
          [#if value_index = 0]
      <h2>Possible Values</h2>
      <table class="aui">
        <tr>
          <th>value</th>
          <th>description</th>
        </tr>
          [/#if]
        <tr>
          <td[#if isDeprecated(value)] class="deprecated"[/#if]>${value.@value}</td>
          <td>
          [#list value.documentation as documentation]
            ${documentation}
          [/#list]
          </td>
        </tr>
          [#if !value_has_next]
      </table>
          [/#if]
        [/#list]
      [#else]
      <h2>XML</h2>
        [#list type.attributes.attribute as attribute]
          [#if attribute_index = 0]
      <h3>Attributes</h3>
      <table class="aui">
        <tr>
          <th>name</th>
          <th>type</th>
          <th>description</th>
        </tr>
          [/#if]
        <tr>
          <td>[#if attributeExists(attribute.@name)]${attribute.@name}[/#if]</td>
          <td>[#if attributeExists(attribute.@typeSchemaId)][#if attributeExists(attribute.@typeName)][#assign typename=attribute.@typeName/][#else][#assign typename="(anonymous)"/][/#if]<a href="${attribute.@typeSchemaId}_${typename}.html">${typename}</a>[#elseif attributeExists(attribute.@typeName)]${attribute.@typeName}[/#if]</td>
          <td>${attribute}</td>
        </tr>
          [#if !attribute_has_next]
      </table>
          [/#if]
        [/#list]
        [#list type.elements.element as element]
          [#if element_index = 0]
      <h3>Elements</h3>
      <table class="aui">
        <tr>
          <th>name (type)</th>
          <th>min/max<br/>occurs</th>
          <th>description</th>
        </tr>
          [/#if]
        <tr>
          <td>
          [#list element.choice as choice]
            [#if choice_index > 0]<br/>or [/#if][#if attributeExists(choice.@schemaId)]<a href="el_${choice.@schemaId}_${choice.@name}.html">${choice.@name}</a>[#else]${choice.@name}[/#if][#if attributeExists(choice.@typeSchemaId)][#if attributeExists(choice.@typeName)][#assign typename=choice.@typeName/][#else][#assign typename="(anonymous)"/][/#if] (<a href="${choice.@typeSchemaId}_${typename}.html">${typename}</a>)[#elseif attributeExists(choice.@typeName)] (${choice.@typeName})[/#if]
          [/#list]
          </td>
          <td>[#if attributeExists(element.@minOccurs)]${element.@minOccurs}[/#if]/[#if attributeExists(element.@maxOccurs)]${element.@maxOccurs}[/#if]</td>
          <td>
          [#list element.documentation as documentation]
            ${documentation}
          [/#list]
          </td>
        </tr>
          [#if !element_has_next]
      </table>
          [/#if]
        [/#list]
        [#list type.value as value]
      <h3>Value</h3>
      <table class="aui">
        <tr>
          <td align="right">Type:</td>
          <td>[#if attributeExists(value.@typeSchemaId)][#if attributeExists(value.@typeName)][#assign typename=value.@typeName/][#else][#assign typename="(anonymous)"/][/#if]<a href="${value.@typeSchemaId}_${typename}.html">${typename}</a>[#elseif attributeExists(value.@typeName)]${value.@typeName}[/#if]</td>
        </tr>
      </table>
      <p>${value}</p>
        [/#list]

        [#if includeExampleJson!true]
      <h2>JSON</h2>
      <table class="aui">
        <tr>
          <th>property</th>
          <th>type</th>
          <th>description</th>
        </tr>
          [#list type.attributes.attribute as attribute]
        <tr>
          <td>[#if attributeExists(attribute.@jsonName)]${attribute.@jsonName}[/#if]</td>
          <td>[#if attributeExists(attribute.@typeSchemaId)][#if attributeExists(attribute.@typeName)][#assign typename=attribute.@typeName/][#else][#assign typename="(anonymous)"/][/#if]<a href="${attribute.@typeSchemaId}_${typename}.html">${typename}</a>[#elseif attributeExists(attribute.@typeName)]${attribute.@typeName}[/#if]</td>
          <td>${attribute}</td>
        </tr>
          [/#list]
          [#list type.elements.element as element]
        <tr>
          <td>[#if attributeExists(element.@jsonName)]${element.@jsonName}[/#if]</td>
          <td>
            [#list element.choice as choice]
              [#if element.@maxOccurs = "unbounded"]array of [/#if][#if choice_index > 0]<br/>or [/#if][#if attributeExists(choice.@schemaId)]<a href="el_${choice.@schemaId}_${choice.@name}.html">${choice.@name}</a>[#else]${choice.@name}[/#if][#if attributeExists(choice.@typeSchemaId)][#if attributeExists(choice.@typeName)][#assign typename=choice.@typeName/][#else][#assign typename="(anonymous)"/][/#if] (<a href="${choice.@typeSchemaId}_${typename}.html">${typename}</a>)[#elseif attributeExists(choice.@typeName)] (${choice.@typeName})[/#if]
            [/#list]
          </td>
          <td>
            [#list element.documentation as documentation]
            ${documentation}
            [/#list]
          </td>
        </tr>
          [/#list]
          [#list type.value as value]
        <tr>
          <td>[#if attributeExists(value.@jsonName)]${value.@jsonName}[/#if]</td>
          <td>[#if attributeExists(value.@typeSchemaId)][#if attributeExists(value.@typeName)][#assign typename=value.@typeName/][#else][#assign typename="(anonymous)"/][/#if]<a href="${value.@typeSchemaId}_${typename}.html">${typename}</a>[#elseif attributeExists(value.@typeName)]${value.@typeName}[/#if]</td>
          <td>${value}</td>
        </tr>
          [/#list]
      </table>
        [/#if]
      [/#if]
    [/@boilerplate]
  [/@file]
[/#macro]
[#macro processJsonType type]
  [@file name="json_" + type?parent.@schemaId + "_" + type.@name + ".html" charset="utf-8"]
    [@boilerplate title=type.@name subnav=[{"title" : "Home", "href" : indexPageName}, {"title" : "JSON" , "href" : "#"}, {"title" : type.@name , "href" : "json_" + type?parent.@schemaId + "_" + type.@name + ".html"}] codeblocks=true]
      <h1>${type.@name}</h1>

      <table class="aui">
      [#if attributeExists(type?parent.@schemaId)]
      <tr>
        <td align="right">JSON Schema ID:</td>
        <td>${type?parent.@schemaId}</td>
      </tr>
      [/#if]
      [#if attributeExists(type?parent.@file)]
      <tr>
        <td align="right">JSON Schema File:</td>
        <td><a href="${type?parent.@file}">${type?parent.@file}</a></td>
      </tr>
      [/#if]
      [#assign sinceTags = getTagValues(type, "since") /]
      [#if sinceTags?size > 0]
      <tr>
        <td align="right">Available Since:</td>
        <td>${sinceTags[0]}</td>
      </tr>
      [/#if]
      [#assign versionTags = getTagValues(type, "version") /]
      [#if versionTags?size > 0]
      <tr>
        <td align="right">Available Version:</td>
        <td>${versionTags[0]}</td>
      </tr>
      [/#if]
      </table>
      [#list type.documentation as documentation]
      <p>${documentation}</p>
      [/#list]
      [#list type.property as property]
        [#if property_index = 0]
      <h2>Properties</h2>
      <table class="aui">
        <tr>
          <th>name</th>
          <th>type</th>
          <th>description</th>
        </tr>
        [/#if]
        <tr>
          <td>[#if attributeExists(property.@name)]${property.@name}[/#if]</td>
          <td>[#if property.@isList = "true"]List of [/#if][#if attributeExists(property.@typeSchemaId)][#if attributeExists(property.@typeName)][#assign typename=property.@typeName/][#else][#assign typename="(anonymous)"/][/#if]<a href="json_${property.@typeSchemaId}_${typename}.html">${typename}</a>[#elseif attributeExists(property.@typeName)]${property.@typeName}[/#if]</td>
          <td>[#if attributeExists(property.@documentation)]${property.@documentation}[/#if]</td>
        </tr>
        [#if !property_has_next]
      </table>
        [/#if]
      [/#list]
      [#list type.enumValue as enumValue]
        [#if enumValue_index = 0]
      <h2>Possible Values</h2>
      <table class="aui">
        <tr>
          <th>value</th>
          <th>description</th>
        </tr>
        [/#if]
        <tr>
          <td>[#list enumValue.value as value]${value} [/#list]</td>
          <td>[#list enumValue.documentation as documentation]${documentation} [/#list]</td>
        </tr>
        [#if !enumValue_has_next]
      </table>
        [/#if]
      [/#list]
    [/@boilerplate]
  [/@file]
[/#macro]
