/**
 * Top level configuration/information object.
 */
define("cq", [ "underscore", "backbone", "exports" ], function (_, Backbone, exports) {
    if (typeof CQ == "undefined" || !CQ) {
        window.CQ = {};
    }

    // Export the Templates object so the CQ variable doesn't shadow the CQ.Templates object when "cq" is require()ed
    // in a module and assigned to "CQ".
    exports.Templates = CQ.Templates;

    // VERSION is resolved by mvn resources plugin
    exports.VERSION = CQ.VERSION = "2.4.15";


    // Provide us with trim method if we don't have one (IE8)
    if(!String.prototype.trim) {
        String.prototype.trim = function () {
            return this.replace(/^\s+|\s+$/g,'');
        };
    }

    /**
     * Provide our own sub classes of the backbone objects for common methods.
     */
    function setupBackbone() {
        exports.View = Backbone.View.extend({
            /**
             * Observes this view's model object for request/sync/error events and sets the data-ajax-request
             * attribute. This is mainly used for testing to tell page objects when ajax operations have finished.
             *
             * @param {string} [attribute] attribute that we are observing
             */
            observeAjaxRequests: function (attribute) {
                var request = attribute ? "request:" + attribute : "request";
                var sync = attribute ? "sync:" + attribute : "sync";
                var error = attribute ? "error:" + attribute : "error";
                var observed = this.model || this.collection;


                observed.on(request, function () {
                    this.$el.attr("data-ajax-request", true);
                }, this);

                observed.on(sync + " " + error, function () {
                    this.$el.attr("data-ajax-request", false);
                }, this);
            }
        });

        exports.Model = Backbone.Model;
        exports.Collection = Backbone.Collection;
        exports.Events = Backbone.Events;
    }

    setupBackbone();
});