define("cq/api/search",
    [
        "jquery",
        "underscore",
        "backbone",
        "ajs"
    ],
    function (
        $,
        _,
        Backbone,
        AJS) {

        /**
         * Remote Search. Cancels ongoing requests when new ones come in.
         *
         * @constructor
         */
        var Search = function() {
            var queryCount = 0;

            this.query = function (params, context) {
                context = context || {};

                var dfd = $.ajax({
                    dataType: "json",
                    cache: false,
                    url: AJS.contextPath() + "/rest/questions/1.0/search/",
                    data: _.extend({
                        type: "question",
                        highlightMatches: true,
                        limit: 6
                    }, params)
                });

                if (queryCount === 0) {
                    this.trigger("activity", true);
                }

                queryCount++;
                dfd.always(_.bind(function () {
                    queryCount--;
                    if (queryCount === 0) {
                        this.trigger("activity", false);
                    }
                }, this));

                function processSearchResults(searchResults) {
                    return _.map(searchResults, function (searchResult) {
                        return searchResult;
                    });
                }

                dfd.done(_.bind(function (data) {
                    data.results = processSearchResults(data.results);

                    this.trigger("respond", data, context);
                }, this));

                // cancel previous request
                if (this.dfd) {
                    this.dfd.abort();
                    this.dfd = null;
                }

                this.dfd = dfd;
            }
        };
        _.extend(Search.prototype, Backbone.Events);

        return Search;
    });