define("cq/api/comment-collection",
    [
        "jquery",
        "underscore",
        "backbone",
        "cq/api/comment",
        "cq/util/analytics",
        "ajs",
        "cq/api/base-collection"
    ],
    function (
        $,
        _,
        Backbone,
        Comment,
        analytics,
        AJS,
        BaseCollection) {

        return BaseCollection.extend({
            model: Comment,

            initialize: function(models, options) {
                this.type = options.type;
                this.questionId = options.questionId;
                this.answerId = options.answerId;
            },

            url: function() {
                if (this.type === "question") {
                    return AJS.contextPath() + "/rest/questions/1.0/questions/" + this.questionId + "/comments";
                } else if (this.type === "answer") {
                    return AJS.contextPath() + "/rest/questions/1.0/questions/" + this.questionId + "/answers/" + this.answerId + "/comments"
                }
            },

            save: function(data) {
                var dfd = $.ajax({
                    type: "POST",
                    url: this.url(),
                    data: data,
                    contentType: "application/json",
                    dataType: "json"
                });
                var commentId = JSON.parse(data).commentId;

                dfd.done(_.bind(function (response) {
                    if (!!commentId) {
                        this.set(new Comment(response));
                    } else {
                        this.add(new Comment(response));
                    }
                }, this));

                if (!!commentId) {
                    analytics.trackEvent(this.type, "editcomment");
                }
                else {
                    analytics.trackEvent(this.type, "addcomment");
                }

                return dfd;
            }
        });
    });

