define("cq/api/answer",
    [
        "jquery",
        "underscore",
        "backbone",
        "cq/api/base-model",
        "cq/util/analytics"
    ],
    function (
        $,
        _,
        Backbone,
        BaseModel,
        analytics) {

        var Answer = BaseModel.extend({

            toggleAccepted: function () {
                var accepted = this.get("accepted");
                var self = this;

                this.trigger("request:accepted", this);
                $.ajax({
                    url: this.url() + "/accept",
                    type: accepted ? "DELETE" : "POST",
                    dataType: "json"
                }).done(function () {
                        analytics.trackEvent("answer", accepted ? "unaccepted" : "accepted");

                        self.trigger("sync:accepted", self);
                    }).error(function () {
                        self.set("accepted", accepted);
                        self.trigger("error:accepted", self);
                    });

                this.set("accepted", !accepted);
            }
        });

        return Answer;
    });