(function($) {
    Confluence.TeamCalendars.Dialogs.getSubCalendarSubscribeDialog = function(options) {

        var callbackHandler = options.callbackHandler;
        var Util = require("tc/util");
        var CalUtil = require("tc/calendar-util");

        var searchSubCalendars = function(dialog, data, urlPath, noResultsFunction, resultsRenderedFunction) {
            var resultsContainer = $(".results", dialog.getCurrentPanel().body);
            $.ajax({
                cache: false,
                converters : {
                    "text json" : function(jsonObject) {
                        return jsonObject;
                    }
                },
                data : data,
                dataFilter : function(data) {
                    var subCalendarsResponseEntity = $.parseJSON(data);
                    if (subCalendarsResponseEntity.success)
                        Confluence.TeamCalendars.mergeSubCalendarObjectsToArray(subCalendarsResponseEntity.payload);
                    return subCalendarsResponseEntity.payload;
                },
                dataType: "json",
                error : function(obj, status, error) {
                    if (noResultsFunction)
                        noResultsFunction(data, resultsContainer);
                },
                success : function(searchResults) {
                    resultsContainer.empty();
                    if (searchResults && searchResults.length) {
                        var resultsTable = $(Confluence.TeamCalendars.Templates.calendarSearchResultTable()),
                            resultsBody = $("tbody", resultsTable),

                            appendResultRow = function(matchingSubCalendar) {
                                resultsBody.append(
                                    $(Confluence.TeamCalendars.Templates.calendarSearchResult({
                                        "name" : matchingSubCalendar.name,
                                        "description" : matchingSubCalendar.description || "",
                                        "relatedSpace" : matchingSubCalendar.spaceName || "",
                                        "numSubscribers" : matchingSubCalendar.subscriberCount
                                    })).click(function() {
                                            var tableRow = $(this),
                                                removeSelection = tableRow.hasClass("active");

                                            if (removeSelection) {
                                                tableRow.removeClass("active");
                                                $(".subcalendar-select", tableRow).removeAttr("checked");
                                            } else {
                                                tableRow.addClass("active");
                                                $(".subcalendar-select", tableRow).attr("checked", "checked");
                                            }

                                            var allUnwatchable = true,
                                                selectedRows = $("tr.active", resultsBody);

                                            selectedRows.each(function() {
                                                if ($(this).data("subCalendar").watchable) {
                                                    allUnwatchable = false;
                                                    return false;
                                                }
                                            });

                                            if (selectedRows.length) {
                                                enableAddButton();
                                                enableWatchCheckbox();
                                            } else {
                                                disableAddButton();
                                                disableWatchCheckbox();
                                            }

                                            if (!selectedRows.length || allUnwatchable)
                                                disableWatchCheckbox();
                                            else if (!allUnwatchable && !removeSelection)
                                                enableWatchCheckbox();

                                    }).data("subCalendar", matchingSubCalendar)
                                );
                            };

                        $.each(searchResults, function(index, searchResult) {
                            if (Confluence.TeamCalendars.isDummySubscriptionParentSubCalendar(searchResult)) {
                                $.each(searchResult.childSubCalendars || [], function(subscriptionIdx, subscriptionSubCalendar) {
                                    appendResultRow(subscriptionSubCalendar);
                                });
                            } else {
                                appendResultRow(searchResult);
                            }
                        });

                        resultsContainer.append(resultsTable);
                        $(".ellipsedColumn", resultsTable).each(function() {
                            var calDesc = $(this);
                            var calDescText = calDesc.text();
                            calDesc.attr("title", calDescText).ThreeDots({ max_rows: 1 });
                        });

                        if (resultsRenderedFunction)
                            resultsRenderedFunction(searchResults);

                    } else {
                        if (noResultsFunction)
                            noResultsFunction(data, resultsContainer);
                    }
                },
                timeout : Confluence.TeamCalendars.ajaxTimeout,
                url : Confluence.TeamCalendars.getCalendarServiceBaseUrl(urlPath)
            });
        };

        var subCalendarSubscribeDialog = (function() {
            var idSubscribeDialog = options.id !== undefined ? options.id : "internal-subscription-calendar-dialog";
            var subscribeDialog = new AJS.Dialog({width : 800, height : 400, id : idSubscribeDialog});

            subscribeDialog.addHeader(AJS.I18n.getText("calendar3.searchcalendars"));

            subscribeDialog.addPanel(
                "",
                Confluence.TeamCalendars.Templates.subscribeDialog(),
                "subscribe-to-subcalendars-panel"
            );

            var dialogBody = subscribeDialog.getCurrentPanel().body;

            $("#subscribe-intro", dialogBody).append(AJS.I18n.getText("calendar3.subscribeintro"));

            $(".create-your-subcalendar", dialogBody).click(function() {
                subscribeDialog.remove();

                var subCalendarDialog = Confluence.TeamCalendars.Dialogs.getSubCalendarCreateDialog("parent", callbackHandler);
                Util.showDialogInUpdatedHeight(subCalendarDialog);
                $("input[name='name']", subCalendarDialog.getCurrentPanel().body).focus();

                return false;
            });

            var searchContainer = $(".search", dialogBody);
            $(".form", searchContainer).submit(function() {
                // This form isn't to be submitted...
                return false;
            });


            var searchRequestTimeout;
            $("textarea[name='query']", searchContainer).text(AJS.I18n.getText("search.name")).addClass("blank-search").keydown(function(jsEvent) {
                if (jsEvent.keyCode === 13)
                    return false;

                var queryInput = $(this),
                    currentQuery = queryInput.hasClass("blank-search") ? queryInput.removeClass("blank-search").val("").val() : queryInput.val();

                if (searchRequestTimeout !== undefined){
                    clearTimeout(searchRequestTimeout);
                }

                searchRequestTimeout = setTimeout(function() {
                    var actualQuery = queryInput.val();
                    if (!queryInput.hasClass("blank-search") && actualQuery && actualQuery !== currentQuery) {
                        searchContainer.addClass("searching");
                        searchSubCalendars(
                            subscribeDialog,
                            $.extend(
                                {
                                    term : actualQuery,
                                    limit : 10,
                                    showSubscriberCount : true
                                },
                                options.searchParams || {}
                            )
                            , "/search/subcalendars.json"
                            , function(data, resultsContainer) {
                                searchContainer.removeClass("searching");
                                disableAddButton();
                                disableWatchCheckbox();
                                resultsContainer.empty().append(
                                        $(document.createElement("span")).addClass("no-subcalendars-found").text(
                                                AJS.format(AJS.I18n.getText("calendar3.nosubcalfound"), data.term)
                                        )
                                );
                            }, function() {
                                searchContainer.removeClass("searching");
                                enableAddButton();
                            }
                        );
                    }

                }, 500);
            }).blur(function() {
                var queryInput = $(this);
                if (!$.trim(queryInput.val()))
                    queryInput.addClass("blank-search").val(AJS.I18n.getText("search.name"));
            });

            if (subscribeDialog.addHelpText && $.isFunction(subscribeDialog.addHelpText)) {
                subscribeDialog.addHelpText(
                        $(document.createElement("span")).addClass("show-popular").html(
                                AJS.I18n.getText("calendar3.showpopularcalendars")
                        )
                );
                // In Confluence 4, it appears that something would be bound to the link. If that is not unbound, a new window would popup
                $("span.show-popular a", subscribeDialog.getCurrentPanel().page.buttonpanel).unbind("click").click(function() {
                    subscribeDialog.remove();
                    Confluence.TeamCalendars.Dialogs.getSubCalendarSubscribeDialog({
                        callbackHandler : callbackHandler,
                        heading: AJS.I18n.getText("calendar3.popularcalendars")
                    }).show();
                    return false;
                });

                subscribeDialog.addHelpText(
                        $(document.createElement("span")).addClass("show-search").html(
                                AJS.I18n.getText("calendar3.showsearchcalendars")
                        )
                );
                $("span.show-search a", subscribeDialog.getCurrentPanel().page.buttonpanel).unbind("click").click(function() {
                    subscribeDialog.remove();
                    Confluence.TeamCalendars.Dialogs.getSubCalendarSubscribeDialog(
                        $.extend(
                            $.extend({}, options),
                            {
                                callbackHandler : callbackHandler,
                                heading: AJS.I18n.getText("calendar3.searchcalendars"),
                                showSearch: true
                            }
                        )
                    ).show();
                    return false;
                });
            }

            var buttonPanel = $(".dialog-button-panel", subscribeDialog.popup.element);

            if (!options.disableWatching) {
                $(document.createElement("input")).attr({
                    type: "checkbox",
                    name: "watch"
                }).addClass("watch-selected-subcalendars").appendTo(buttonPanel);
                $(document.createElement("span")).addClass("watch-select-subcalendars-label").text(AJS.I18n.getText("calendar3.watchselectedcalendars")).appendTo(buttonPanel);
            }

            $("<span class='spinner hidden aui-icon aui-icon-wait'></span>").appendTo(buttonPanel);

            subscribeDialog.addButton(AJS.I18n.getText("add.word"), function() {
                var selectedSubCalendars = $("tr.active", dialogBody);

                if (selectedSubCalendars.length && !callbackHandler.isProcessingSubCalendar()) {
                    callbackHandler.setProcessingSubCalendar(true);
                    disableAddButton();
                    disableWatchCheckbox();
                    showSpinner();

                    $.ajax({
                        cache: false,
                        converters : {
                            "text json" : function(jsonObject) {
                                return jsonObject;
                            }
                        },
                        data: (function() {
                            var requestData = {
                                color: callbackHandler.getNextCalendarColor(),
                                watchSubCalendars: $(".watch-selected-subcalendars", subscribeDialog.popup.element).is(":checked")
                            };

                            var subCalendarIds = [];
                            selectedSubCalendars.each(function() {
                                subCalendarIds.push($(this).data("subCalendar").id);
                            });
                            requestData.subCalendarIds = subCalendarIds;

                            if (callbackHandler.getIncludedCalendars())
                                requestData.include = callbackHandler.getIncludedCalendars();

                            CalUtil.putCalendarContextParams(requestData);

                            return requestData;
                        })(),
                        dataFilter : function(data) {
                            var subCalendarsResponseEntity = $.parseJSON(data);
                            if (subCalendarsResponseEntity.success)
                                Confluence.TeamCalendars.mergeSubCalendarObjectsToArray(subCalendarsResponseEntity.payload);
                            return subCalendarsResponseEntity;
                        },
                        dataType : "json",
                        error: function(XMLHttpRequest, textStatus, errorThrown) {
                            Confluence.TeamCalendars.showAjaxError(dialogBody, XMLHttpRequest, textStatus, errorThrown, "error-subcalendar-refresh");
                            callbackHandler.setProcessingSubCalendar(false);
                            enableAddButton();
                            enableWatchCheckbox();
                            hideSpinner();
                        },
                        success : function(responseEntity) {

                            if(!responseEntity.success) {
                                Confluence.TeamCalendars.setGenericErrors(dialogBody, AJS.I18n.getText("calendar3.error.unknown"), "error-subcalendar-refresh");
                                return;
                            }

                            callbackHandler.setSubCalendars(
                                    AJS.$.map(selectedSubCalendars, function(each){return $(each).data("subCalendar").id}).toString(),
                                    responseEntity.payload);
                            callbackHandler.updateAvailableSubCalendarsInSubCalendarPanel();
                            //TODO How about a reset method?!
                            Confluence.TeamCalendars.setGenericErrors(dialogBody, null, "error-subcalendar-refresh");
                            subscribeDialog.remove();
                            callbackHandler.setProcessingSubCalendar(false);
                        },
                        type: "PUT",
                        timeout : Confluence.TeamCalendars.ajaxTimeout,
                        url : Confluence.TeamCalendars.getCalendarServiceBaseUrl("/subcalendars/subscribe.json")
                    });
                } else {
                    subscribeDialog.remove();
                }
            }, "subscribe-to-subcalendar-button");

            subscribeDialog.addLink(AJS.I18n.getText("cancel.name"), function() {
                subscribeDialog.remove();
                return false;
            });

            return subscribeDialog;
        })();

        var dialogPanel = subCalendarSubscribeDialog.getCurrentPanel();

        var dialogPanelBody = dialogPanel.body;

        var disableAddButton = function() {
            $(".subscribe-to-subcalendar-button", "#internal-subscription-calendar-dialog")
                .attr("disabled", "disabled")
                .addClass("ui-state-disabled");
        }

        var enableAddButton = function() {
            $(".subscribe-to-subcalendar-button", "#internal-subscription-calendar-dialog")
                .removeAttr("disabled", "disabled")
                .removeClass("ui-state-disabled");
        }

        var disableWatchCheckbox = function() {
            $(".watch-selected-subcalendars", "#internal-subscription-calendar-dialog").disable();
        }

        var enableWatchCheckbox = function() {
            $(".watch-selected-subcalendars", "#internal-subscription-calendar-dialog").enable();
        }

        var showSpinner = function() {
            $(".spinner", "#internal-subscription-calendar-dialog").removeClass("hidden");
        }

        var hideSpinner = function() {
            $(".spinner", "#internal-subscription-calendar-dialog").addClass("hidden");
        }

        var mergedOptions = $.extend({
            heading: AJS.I18n.getText("calendar3.searchcalendars")
        }, options);

        var header = dialogPanel.page.header;

        header.empty().text(mergedOptions.heading);

        if (mergedOptions.showSearch) {
            header.removeClass("welcome-heading-with-logo");
        } else {
            header.addClass("welcome-heading-with-logo");
        }


        if (Confluence.TeamCalendars.isPDLEnabled()) {
            if (mergedOptions.showSearch) {
                dialogPanelBody.removeClass("popular").addClass("search");
            } else {
                dialogPanelBody.removeClass("search").addClass("popular");
            }
        }

        $(".results", dialogPanelBody).empty();
        $(".mode", dialogPanelBody).removeClass().addClass("mode" + (mergedOptions.showSearch ? "" : " new-user"));

        var watchSubCalendarsCheckbox = $(".watch-selected-subcalendars");
        disableWatchCheckbox();

        if (callbackHandler.isAutoWatchSet()) {
            watchSubCalendarsCheckbox.attr("checked", "checked");
        } else {
            watchSubCalendarsCheckbox.removeAttr("checked");
        }

        disableAddButton();
        disableWatchCheckbox();

        if (mergedOptions.showSearch) {
            if (Confluence.TeamCalendars.isCalendarSearchDisabled) {
                $("#tc-subscribe-no-search-warning", dialogPanelBody).removeClass("hidden");
                $(".search", dialogPanelBody).addClass("hidden");

                searchSubCalendars(
                    subCalendarSubscribeDialog,
                    {},
                    "/search/subcalendars/all",
                    hideSpinner,
                    function() {
                        $("#tc-subscribe-no-search-warning .spinner", dialogPanelBody).addClass("hidden");
                    });
            }

            $("input[name='query']", dialogPanelBody).val("");
            $(".dialog-tip .show-popular", dialogPanel.page.buttonpanel).removeClass("hidden");
            $(".dialog-tip .show-search", dialogPanel.page.buttonpanel).addClass("hidden");
        } else {
            var preamble = $(".preamble", dialogPanelBody).addClass("loading");
            var hideSpinner = function() {
                preamble.removeClass("loading");
            };

            searchSubCalendars(
                subCalendarSubscribeDialog,
                $.extend({ limit: 10 }, options.searchParams || {}),
                "/search/subcalendars/popular",
                hideSpinner,
                function() {
                    hideSpinner();
                }
            );

            $(".dialog-tip .show-popular", dialogPanel.page.buttonpanel).addClass("hidden");
            $(".dialog-tip .show-search", dialogPanel.page.buttonpanel).removeClass("hidden");
        }

        return subCalendarSubscribeDialog;
    };
}(AJS.$));
