/**
 * What is this and how this works:
 *
 * This JS is pulled in by PostInstallDialogInjectFilter. It intercepts GET requests to /plugins/servlet/upm.
 * The ServletFilter does this only when Team Calendars is licensed so we don't end up showing the post install dialog when it isn't.
 * This JS would then popup a "Get started" dialog on top of UPM (see https://jira.atlassian.com/browse/TEAMCAL-798).
 *
 * So - how does it know when to pop the dialog up?
 * 1) After the plugin is installed and licensed (via UPM postback), UPM will display a dialog containing a button that sends the user to our post.install.url,
 * which basically is PostInstallDialogInjectFilter. The ServletFilter will then redirect to /plugins/servlet/upm#manage/com.atlassian.confluence.extra.team-calendars,
 * pulling in this JS file. UPM recognises the plugin key in the URL and scrolls to Team Calendars, and when it does this, it will fire a "pluginFocused" event that
 * this JS will listen to. When that event is received, the post install dialog will be shown.
 *
 * 2) We also try to show the dialog when the user uploads a new version of Team Calendars via the UPM.
 * We do this because UPM ignores post.install.url in the uploaded plugin. We do this by listening for AJS.Dialog show events.
 * If it's the plugin status dialog and it is showing Team Calendar details, we make the button and 'X' link open up our
 * post install dialog.
 *
 * So as you can see, it's a bit of a hack. Well, not a bit. Quite a hack. I'm not super happy with this either. So don't look
 * at me or anything in here thinking I've committed federal crime. I cried a little when I wrote this. I think. But for my
 * safety's sake, I won't be sharing my contact details or my address with you. This is now your problem, and I wish you best of luck.
 */
;jQuery(function($) {
    var PostInstall = {
        showNextStepsDialog : function() {
            var theDialog = new AJS.Dialog({
                "width" : 860,
                "height" : 550,
                "id" : "tc-post-install-dialog"
            }), videoId = "9g35DKCaoR4";

            theDialog.addHeader(AJS.I18n.getText("postinstall.dialog.title"));
            theDialog.addPanel(
                "",
                Confluence.TeamCalendars.Templates.postInstallDialog({ "youtubeVideoId" : videoId }),
                "post-install-panel"
            );
            theDialog.addLink(AJS.I18n.getText('close.name'), function() {
                //The reason we set source to "" and wait to remove the dialog is because of an IE9 bug.
                //See TEAMCAL-1211 and https://groups.google.com/forum/#!msg/youtube-api-gdata/2JcIaw43dco/Crd7mMHSLPsJ
                $(".video-iframe").attr("src", "");
                theDialog.hide();
                setTimeout(function() {
                    theDialog.remove();
                }, 500);
                return false;
            });

            var $dialogPanel = theDialog.getCurrentPanel().body,
                $rightColumn = $(".right-column", $dialogPanel),
                $durationSpan = $("span", $rightColumn);

            $(".default-content", $dialogPanel).click(function() {
                $(this).fadeOut(500, function() {
                    $(".enlarged-video", $dialogPanel).append(
                        $("<iframe/>", {
                            "class": "video-iframe",
                            "width" : "500",
                            "height" : "251",
                            "src" : "//www.youtube.com/embed/" + videoId,
                            "frameborder" : "0",
                            "allowfullscreen" : "false"
                        })
                    )
                })
            });

            $.ajax({
                "cache" : false,
                "crossDomain" : true,
                "dataType" : "json",
                "url" : "http://gdata.youtube.com/feeds/api/videos/" + encodeURIComponent(videoId) +  "?v=2&alt=json",
                "success" : function(youtubeData) {
                    var vMediaGroup = youtubeData.entry["media$group"],
                        durationSecs = vMediaGroup["media$content"][0].duration,
                        durationDisplayMinutes = Math.round(durationSecs / 60),
                        durationDisplaySecs = durationSecs - durationDisplayMinutes * 60;

                    $durationSpan.text(AJS.format(
                        $durationSpan.data("duration-format-string"),
                        durationDisplayMinutes,
                        durationDisplaySecs < 10 ? "0" + durationDisplaySecs : durationDisplaySecs
                    ));
                },
                timeout : Confluence.TeamCalendars.ajaxTimeout
            });

            theDialog.show();
            theDialog.updateHeight(); // Important - so the button panel height is at the right height.
        }
    };

    if (upm) {
        var isBodyAboutPostInstallOrUpdate = function(someText) {
                return $.inArray(
                    someText,
                    [
                        AJS.params["upm.messages.install.eval.nextstep"],
                        AJS.params["upm.messages.install.purchased.nextstep"],
                        AJS.params["upm.messages.install.success.already.evaluating.nextstep"],
                        AJS.params["upm.messages.install.success.already.purchased.nextstep"]
                    ]
                ) >= 0;
            },

            isUpmStatusDialog = function(aDialog) {
                return aDialog.id === "upm-plugin-status-dialog";
            },

            isPluginStatusDialogAboutTeamCalendars = function(aDialog) {
                return isUpmStatusDialog(aDialog) && $(".plugin-name-version .plugin-name", aDialog.getCurrentPanel().body).text() === "Team Calendars";
            };

//        PostInstall.showNextStepsDialog(); // For quick testing
//        PostInstall.postPluginInstalledNotification(); // For quick testing

        // For the "Get Started" button
        $("div.upm-details").live(
            "detailsLoaded",
            null,
            function() {
                if (upm.createHash) { //Some older versions of the UPM don't have this. The Get started buttons don't seem to exist in these UPM versions anyway.
                    $("#upm-plugin-" + upm.createHash("com.atlassian.confluence.extra.team-calendars", "manage") + " .upm-get-started").unbind("click").click(function() {
                        PostInstall.showNextStepsDialog();
                        return false;
                    });
                }
            }
        );

        // For some reasons, $.aop isn't working as I expected. The function arguments are all wrong!
        // In UPM, the plugin status dialog would be shown when the plugin is installed, updated or the license configured.
        var originalUpmShowPluginStatusDialog = upm.showPluginStatusDialog;
        upm.showPluginStatusDialog = function(heading, pluginElement, body, button, buttonHandler, htmlBody) {
            originalUpmShowPluginStatusDialog(
                heading,
                pluginElement,
                body,
                button,
                (function() {
                    return function(pluginStatusDialog) {
                        if (isPluginStatusDialogAboutTeamCalendars(pluginStatusDialog) && isBodyAboutPostInstallOrUpdate(body)) {
                            if (upm.logAnalytics) {
                                pluginElement.find = function () {
                                    return {
                                        val : function (){
                                            return pluginElement.key;
                                        }
                                    };
                                }
                                upm.logAnalytics('postinstall', pluginElement, { dialog : true });
                            }


                            pluginStatusDialog.remove();
                            PostInstall.showNextStepsDialog();
                        } else if (buttonHandler) {
                            buttonHandler(pluginStatusDialog);
                        }
                    }
                })(),
                htmlBody
            );
        };

    }
});

