define("tc/subcalendar-entry-view",
    [
        "jquery",
        "underscore",
        "tc/calendar-util",
        "tc-backbone",
        "tc/child-subcalendar-entry-view",
        "tc/subcalendar-menu-view",
        "tc/subcalendar-displayer"
    ],
    function (
        $,
        _,
        CalUtil,
        Backbone,
        ChildSubCalendarEntryView,
        SubCalendarMenuView,
        SubCalendarDisplayer
    ) {

        "use strict";

        var SubCalendarEntryView = Backbone.View.extend({
            initialize: function(options) {
                this.cache = options.cache;
                this.CalendarPlugin = options.CalendarPlugin;
                this.subCalendar = options.subCalendar;
                this.calendarDiv = options.calendarDiv;
                this.template = Confluence.TeamCalendars.Templates.subCalendarPanelEntry;

                this.childSubCalendarIds = [];
                this.childSubCalendarViews = [];

                AJS.trigger("calendar.loaded", this.subCalendar);
            },

            events: {
                "click .subcalendar-name" : "_onClick"
            },

            render: function() {
                this.$el.html(this.template({
                    "subCalendar": this.subCalendar,
                    "autoConvertSupported": this.CalendarPlugin.isAutoConvertSupported(this.calendarDiv),
                    "subCalendarClasses": this.CalendarPlugin.getParameter(this.calendarDiv, "subCalendarColorClass")
                }));

                this.entryView = this.$(".subcalendar-item");

                this._ellipsisLongCalendarNames();
                this._renderChildSubCalendars();
                this._initEventsVisibility();

                if(!CalUtil.isSingleCalendarView(this.calendarDiv)) {
                    this.subcalendarDisplayer = new SubCalendarDisplayer({
                        CalendarPlugin: this.CalendarPlugin,
                        calendarDiv: this.calendarDiv,
                        entryView: this.entryView,
                        subCalendar: this.subCalendar,
                        childSubCalendarIds: this.childSubCalendarIds,
                        childSubCalendarViews: this.childSubCalendarViews
                    });
                }

                if(CalUtil.isSpaceCalendarView(this.calendarDiv) && !CalUtil.isDummySubscriptionParentSubCalendar(this.subCalendar) && this.subCalendar.spaceKey !== undefined){
                    this.$(".subcalendar-name").addClass("header-color");
                }

                this.menuView = new SubCalendarMenuView({
                    "cache": this.cache,
                    "CalendarPlugin": this.CalendarPlugin,
                    "calendarDiv": this.calendarDiv,

                    "subCalendar": this.subCalendar,
                    "subCalendarEntryView": this.entryView,

                    "autoConvertSupported": this.CalendarPlugin.isAutoConvertSupported(this.calendarDiv),
                    "subCalendarClasses": this.CalendarPlugin.getParameter(this.calendarDiv, "subCalendarColorClass"),
                    "template": Confluence.TeamCalendars.Templates.subCalendarMenu,

                    "subcalendarDisplayer": this.subcalendarDisplayer
                });
                this.$(".subcalendar-info").append(this.menuView.render());

                return this.$el;
            },

            _ellipsisLongCalendarNames: function() {
                this.$(".subcalendar-name").attr("title", this.$(".ellipsis_text").text());
            },

            _renderChildSubCalendars: function() {
                if (this.subCalendar.childSubCalendars) {
                    this.childSubCalendarIds = [];
                    this.childSubCalendarViews = [];

                    var that = this;

                    _.each(this.subCalendar.childSubCalendars, function (childSubCalendar) {
                        var customEventTypes = childSubCalendar.customEventTypes;
                        if (customEventTypes && customEventTypes.length) {
                            _.each(customEventTypes, function (customEventType) {
                                that._renderChildSubCalendar(childSubCalendar, customEventType);
                            });
                        } else {
                            that._renderChildSubCalendar(childSubCalendar);
                        }
                    });
                }
            },

            _renderChildSubCalendar: function(childSubCalendar, customEventType) {
                var $childSubCalendarDiv = this.$(".child-subcalendars");
                var options = {
                    "cache": this.cache,
                    "CalendarPlugin": this.CalendarPlugin,
                    "calendarDiv": this.calendarDiv,
                    "parentView": this.entryView,
                    "parentSubCalendar": this.subCalendar,
                    "childSubCalendar": childSubCalendar
                };

                if(customEventType) {
                    options.customEventType = customEventType;
                    options.template = Confluence.TeamCalendars.Templates.customEventTypePanelEntry;
                } else {
                    options.template = Confluence.TeamCalendars.Templates.childSubCalendarPanelEntry;
                }

                var $childView = new ChildSubCalendarEntryView(options).render();

                $childSubCalendarDiv.append($childView);

                this.childSubCalendarIds.push(childSubCalendar.id);
                this.childSubCalendarViews.push($childView.find(".child-subcalendar"));
            },

            _onClick: function () {
                // do not allow to click on calendar to hide/show it in single calendar page
                if(!CalUtil.isSpaceCalendarView(this.calendarDiv) || CalUtil.isDummySubscriptionParentSubCalendar(this.subCalendar) || this.subCalendar.spaceKey === undefined) {
                    return;
                }

                Confluence.TeamCalendars.fireEventForAnalytics("view.calendar.detail.click");

                window.location.href = AJS.contextPath() + "/display/"
                    + encodeURIComponent(this.subCalendar.spaceKey)
                    + "/calendar/" + encodeURIComponent(this.subCalendar.subscriptionId || this.subCalendar.id)
                    + "?calendarName=" + encodeURIComponent(this.subCalendar.name);
            },

            // Display events of sub-calendar (and its child sub-calendars) if not disabled.
            _initEventsVisibility: function () {
                var enabledSubCalendarIds = [];
                var disabledSubCalendarIds = [];

                if (CalUtil.isSubscriptionSubCalendar(this.subCalendar)) {
                    if (this.subCalendar.eventsHidden || $.inArray(this.subCalendar.id, disabledSubCalendarIds) !== -1) {
                        this.entryView.addClass("subcalendar-disabled");
                        disabledSubCalendarIds.push(this.subCalendar.id);
                    } else {
                        if (!CalUtil.isDummySubscriptionParentSubCalendar(this.subCalendar)) {
                            enabledSubCalendarIds.push(this.subCalendar.id);
                        }
                    }
                }

                _.each(this.childSubCalendarViews, function (view) {
                    var childSubCalendar = this.CalendarPlugin.getSubCalendar(this.calendarDiv, view.data("subCalendarId"));

                    if (!CalUtil.isSingleCalendarView(this.calendarDiv) && (childSubCalendar.eventsHidden || $.inArray(childSubCalendar.id, disabledSubCalendarIds) !== -1)) {
                        view.addClass("subcalendar-disabled");
                        disabledSubCalendarIds.push(childSubCalendar.id);
                    } else {
                        enabledSubCalendarIds.push(childSubCalendar.id);
                    }
                }, this);


                if (enabledSubCalendarIds.length) {
                    this.CalendarPlugin.addSubCalendarEventSource(this.calendarDiv, enabledSubCalendarIds);
                }

                if (disabledSubCalendarIds.length) {
                    this.entryView.addClass("subcalendar-disabled");
                }
                if (this.childSubCalendarViews.length) {
                    this.CalendarPlugin.checkCalendarHasAllChildDisable(this.entryView);
                } else {
                    if (!CalUtil.isSingleCalendarView(this.calendarDiv) && this.subCalendar.eventsHidden) {
                        this.entryView.addClass("subcalendar-disabled");
                    }
                }
            }
        });

        return SubCalendarEntryView;
    }
);