define("tc/subcalendar-displayer",
    [
        "jquery",
        "underscore",
        "tc/calendar-util"
    ],
    function (
        $,
        _,
        CalUtil
    ) {
        "use strict";

        var SubCalendarDisplayer = function(options) {

            var CalendarPlugin = options.CalendarPlugin,
                calendarDiv = options.calendarDiv,
                entryView = options.entryView,
                subCalendar = options.subCalendar,
                // for parent entry
                childSubCalendarIds = options.childSubCalendarIds,
                childSubCalendarViews = options.childSubCalendarViews,
                // for child entry
                parentView = options.parentView,
                parentSubCalendar = options.parentSubCalendar;

            var displayCalendar = function() {
                var subCalendarIds;
                var isChildEntryView = entryView.hasClass("child-subcalendar");

                if (isChildEntryView) {
                    subCalendarIds = [subCalendar.id];
                } else {
                    subCalendarIds = _.clone(childSubCalendarIds);
                }

                var isEventsHidden = !entryView.hasClass("subcalendar-disabled");

                entryView.toggleClass("subcalendar-disabled", isEventsHidden);

                // toggle all child entries if this is parent entry
                if (!isChildEntryView) {
                    entryView.toggleClass("allchildsubcalendar-disabled", isEventsHidden);

                    _.each(childSubCalendarViews, _.bind(function ($view) {
                        $view.toggleClass("subcalendar-disabled", isEventsHidden);
                    }, this));
                }

                if (!CalUtil.isDummySubscriptionParentSubCalendar(isChildEntryView ? parentSubCalendar : subCalendar)) {
                    subCalendarIds.push(subCalendar.id);
                }

                if(!CalUtil.isSingleCalendarView(calendarDiv)) {
                    CalendarPlugin.setSubCalendarEventsHidden(calendarDiv, subCalendarIds, isEventsHidden, parentView);
                }

                if (isEventsHidden) {
                    CalendarPlugin.removeSubCalendarEventSource(calendarDiv, subCalendarIds);
                } else {
                    CalendarPlugin.addSubCalendarEventSource(calendarDiv, subCalendarIds);
                }

                var analyticsEvent = "";
                if(isChildEntryView){
                    if(isEventsHidden){
                        analyticsEvent = "hide.event.click.";
                    } else {
                        analyticsEvent = "show.event.click.";
                    }
                } else {
                    if(isEventsHidden){
                        analyticsEvent = "hide.calendar.click.";
                    } else {
                        analyticsEvent = "show.calendar.click.";
                    }
                }

                if(CalUtil.isSingleCalendarView(calendarDiv)){
                    analyticsEvent += "singleCalendar";
                } else {
                    analyticsEvent += Confluence.TeamCalendars.getCalendarContext();
                }

                Confluence.TeamCalendars.fireEventForAnalytics(analyticsEvent);
            };

            return {
                toggleVisibility: function() {
                    displayCalendar();
                }
            }
        };

        return SubCalendarDisplayer;
    }
);
