define("tc/non-space-calendars-warning-view",
    [
        "jquery",
        "underscore",
        "tc-backbone",
        "ajs",
        "tc/calendar-util",
        "tc/non-space-calendars-dialog-view"
    ],
    function (
        $,
        _,
        Backbone,
        AJS,
        CalUtil,
        NonSpaceCalendarsDialogView
    ) {

        "use strict";

        var NonSpaceCalendarsWarningView = Backbone.View.extend({
            events: {
                "click .fix-calendars-link": "_onFixCalendarLinkClick"
            },

            initialize: function (options) {
                this.CalendarPlugin = options.CalendarPlugin;
                this.calendarDiv = options.calendarDiv;
                this.cache = options.cache;
            },

            render: function (nonSpaceCalendars) {

                this.nonSpaceCalendars = nonSpaceCalendars;
                this.$(".title strong").text(AJS.I18n.getText("calendar3.warning.non.space.calendars.title", this.nonSpaceCalendars.length));

                if (this.nonSpaceCalendars && this.nonSpaceCalendars.length > 0) {
                    this.show();
                } else {
                    this.hide();
                }
            },

            show: function () {
                this.$el.removeClass("hidden");
            },

            hide: function () {
                this.$el.addClass("hidden");
            },

            _onFixCalendarLinkClick: function () {
                if (!this.nonSpaceCalendarsDialogView) {
                    this.nonSpaceCalendarsDialogView = new NonSpaceCalendarsDialogView({
                        subCalendars: this.nonSpaceCalendars,
                        CalendarPlugin: this.CalendarPlugin,
                        calendarDiv: this.calendarDiv,
                        cache: this.cache
                    });
                }

                this.nonSpaceCalendarsDialogView.setSubCalendars(this.nonSpaceCalendars);
                this.nonSpaceCalendarsDialogView.render();

                CalUtil.fireEventForAnalytics("non.space.calendars.upgrade.link.click");

                return false;
            }
        });

        return NonSpaceCalendarsWarningView;
    }
);